/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.model.factory;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class DefaultValueCache {
    private static Map<Class, Map<String, Object>> staticDefault = new HashMap<Class, Map<String, Object>>();
    private static Map<Class, LinkedHashMap<Method, Object>> valueCache = new HashMap<Class, LinkedHashMap<Method, Object>>();
    private static Map<Class, Map<String, Object>> optionalProperties = new HashMap<Class, Map<String, Object>>();

    public static Map<String, Object> optionalProperty(Class modelClass) {
        return optionalProperties.get(modelClass);
    }

    static void defaultValues(Class clazz, LinkedHashMap<Method, Object> instance) {
        LinkedHashMap<Method, Object> safe = new LinkedHashMap<Method, Object>();
        for (Map.Entry<Method, Object> entry : instance.entrySet()) {
            Object value = entry.getValue();
            if (value instanceof Map) {
                safe.put(entry.getKey(), Collections.unmodifiableMap((Map)value));
                continue;
            }
            if (value instanceof List) {
                safe.put(entry.getKey(), Collections.unmodifiableList((List)value));
                continue;
            }
            safe.put(entry.getKey(), entry.getValue());
        }
        valueCache.put(clazz, safe);
    }

    static boolean hasDefaultValues(Class clazz) {
        return valueCache.containsKey(clazz);
    }

    static LinkedHashMap<Method, Object> defaultValues(Class clazz) {
        LinkedHashMap<Method, Object> result = new LinkedHashMap<Method, Object>();
        for (Map.Entry<Method, Object> entry : valueCache.get(clazz).entrySet()) {
            if (entry.getValue() instanceof Map) {
                Map m = (Map)entry.getValue();
                result.put(entry.getKey(), new LinkedHashMap(m));
                continue;
            }
            if (entry.getValue() instanceof List) {
                List l = (List)entry.getValue();
                result.put(entry.getKey(), new ArrayList(l));
                continue;
            }
            result.put(entry.getKey(), entry.getValue());
        }
        return result;
    }

    static Map<String, Object> staticDefaultValues(Class modelClass) {
        Object gain;
        Object variations;
        if (staticDefault.containsKey(modelClass)) {
            return staticDefault.get(modelClass);
        }
        HashMap<String, Object> defaultValues = new HashMap<String, Object>();
        for (Field field : modelClass.getDeclaredFields()) {
            if (!Modifier.isStatic(field.getModifiers())) continue;
            try {
                defaultValues.put(field.getName(), field.get(null));
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        if (defaultValues.containsKey("variations") && (variations = defaultValues.get("variations")) instanceof Boolean) {
            DefaultValueCache.ensure(modelClass).put("variations", variations);
        }
        if (defaultValues.containsKey("peakGain") && ((gain = defaultValues.get("peakGain")) instanceof Integer || gain instanceof Double)) {
            DefaultValueCache.ensure(modelClass).put("peakGain", gain);
        }
        staticDefault.put(modelClass, defaultValues);
        return defaultValues;
    }

    private static Map<String, Object> ensure(Class modelClass) {
        Map<String, Object> map = optionalProperties.get(modelClass);
        if (map == null) {
            map = new HashMap<String, Object>();
            optionalProperties.put(modelClass, map);
        }
        return map;
    }
}

