/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.model.factory;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.seamcat.model.factory.DataFileImpl;
import org.seamcat.tabulardataio.TabularDataFactory;
import org.seamcat.tabulardataio.TabularDataSaver;

public class DataSaver
implements Runnable {
    private static final List<DataFileImpl> currentSaves = new LinkedList<DataFileImpl>();
    private static boolean running = true;
    private static boolean stopped = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void add(DataFileImpl dataFile) {
        List<DataFileImpl> list = currentSaves;
        synchronized (list) {
            currentSaves.add(dataFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        HashMap<DataFileImpl, TabularDataSaver> savers = new HashMap<DataFileImpl, TabularDataSaver>();
        while (running) {
            try {
                List<DataFileImpl> list = currentSaves;
                synchronized (list) {
                    ArrayList<DataFileImpl> removed = new ArrayList<DataFileImpl>();
                    for (DataFileImpl currentSave : currentSaves) {
                        if (!currentSave.isWritingStarted()) {
                            File file = currentSave.getFile();
                            savers.put(currentSave, TabularDataFactory.newSaverForFile(file));
                        }
                        TabularDataSaver saver = (TabularDataSaver)savers.get(currentSave);
                        ConcurrentLinkedQueue queue = currentSave.getQueue();
                        while (!queue.isEmpty()) {
                            Object value = queue.poll();
                            if (value instanceof Boolean) {
                                saver.close();
                                savers.remove(currentSave);
                                removed.add(currentSave);
                                continue;
                            }
                            saver.addRow((Object[])value);
                        }
                    }
                    for (DataFileImpl dataFile : removed) {
                        currentSaves.remove(dataFile);
                    }
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            catch (RuntimeException e) {
                e.printStackTrace();
            }
        }
        stopped = true;
    }

    public static void stop() {
        running = false;
        while (!stopped) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }
}

