/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.model.factory;

import java.io.File;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.seamcat.model.functions.DataFile;
import org.seamcat.presentation.DialogHelper;
import org.seamcat.tabulardataio.FileFormat;
import org.seamcat.tabulardataio.TabularDataFactory;

public class DataFileImpl
implements DataFile {
    private File file;
    private ConcurrentLinkedQueue queue;
    private boolean writingStarted;

    public DataFileImpl(File file) {
        this.file = file;
        this.queue = new ConcurrentLinkedQueue();
        this.writingStarted = false;
        this.validate();
    }

    private void validate() {
        if (this.file.exists()) {
            DialogHelper.cannotOverwriteError(this.file.getName());
            throw new RuntimeException("File already exists");
        }
        FileFormat format = TabularDataFactory.findByFile(this.file);
        if (format == null) {
            DialogHelper.fileExtensionNotRecognized(this.file.getName());
            throw new RuntimeException("Unknown file extension for file: " + this.file.getName());
        }
    }

    @Override
    public void addRow(String ... data) {
        this.queue.add(data);
    }

    @Override
    public void addRow(Number ... data) {
        this.queue.add(data);
    }

    @Override
    public void close() {
        this.queue.add(false);
        while (!this.queue.isEmpty()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public File getFile() {
        return this.file;
    }

    public ConcurrentLinkedQueue getQueue() {
        return this.queue;
    }

    public boolean isWritingStarted() {
        return this.writingStarted;
    }

    public void setWritingStarted() {
        this.writingStarted = true;
    }
}

