/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.model.factory;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Map;
import org.seamcat.model.factory.Factory;
import org.seamcat.model.factory.PrototypeInvocationHandler;
import org.seamcat.model.factory.ProxyHelper;
import org.seamcat.model.plugin.builder.Returner;

class BuildersImpl
implements Factory.Builders {
    protected static ThreadLocal<Method> method = new ThreadLocal();
    protected static ThreadLocal<Map<Method, Object>> values = new ThreadLocal();

    BuildersImpl() {
    }

    @Override
    public <T> T prototype(Class<T> clazz, T t) {
        PrototypeInvocationHandler<T> handler = new PrototypeInvocationHandler<T>(clazz, t);
        return (T)Proxy.newProxyInstance(clazz.getClassLoader(), new Class[]{clazz}, handler);
    }

    @Override
    public <T> T prototype(Class<T> clazz) {
        return this.prototype(clazz, null);
    }

    @Override
    public <V> Returner<V> when(V value) {
        final Map<Method, Object> values = BuildersImpl.values.get();
        final Method method = BuildersImpl.method.get();
        return new Returner<V>(){

            @Override
            public V thenReturn(V value) {
                values.put(method, value);
                return value;
            }
        };
    }

    @Override
    public <T> T build(T prototype) {
        InvocationHandler invocationHandler;
        if (prototype instanceof Proxy && (invocationHandler = Proxy.getInvocationHandler(prototype)) instanceof PrototypeInvocationHandler) {
            return ((PrototypeInvocationHandler)invocationHandler).build();
        }
        throw new RuntimeException("Not a prototype instance");
    }

    @Override
    public <T> T defaultInstance(Class<T> clazz) {
        return ProxyHelper.newInstance(clazz);
    }
}

