/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.model.distributions;

import org.seamcat.model.distributions.AbstractDistribution;
import org.seamcat.model.distributions.UniformDistributionImpl;
import org.seamcat.model.distributions.UniformPolarAngleDistribution;
import org.seamcat.model.functions.Bounds;
import org.seamcat.model.mathematics.Mathematics;

public class UniformPolarAngleDistributionImpl
extends AbstractDistribution
implements UniformPolarAngleDistribution {
    private final Bounds bounds;

    public UniformPolarAngleDistributionImpl(double maxAngle) {
        super(0.0, 0.0, maxAngle, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        this.bounds = new Bounds(-maxAngle, maxAngle, true);
    }

    @Override
    public Bounds getBounds() {
        return this.bounds;
    }

    @Override
    public double trial() {
        double rU = new UniformDistributionImpl(-1.0, 1.0).trial();
        double rA = 57.29577951308232 * Mathematics.asinD(rU * Mathematics.sinD(this.getMaxAngle() * Math.PI / 180.0));
        return rA;
    }

    public String toString() {
        return "Uniform Polar Angle distribution(" + this.getMaxAngle() + ")";
    }
}

