/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.model.distributions;

import org.seamcat.model.distributions.AbstractDistribution;
import org.seamcat.model.distributions.GaussianDistribution;
import org.seamcat.model.distributions.LogNormalDistribution;
import org.seamcat.model.factory.Factory;
import org.seamcat.model.functions.Bounds;

public class LogNormalDistributionImpl
extends AbstractDistribution
implements LogNormalDistribution {
    private Bounds BOUNDS;
    private double max;
    private double mean;
    private double stdDev;
    private GaussianDistribution gaussian;

    public LogNormalDistributionImpl(double max, double mean, double stdDev) {
        super(0.0, max < Math.exp(mean) ? Math.exp(mean) : max, 0.0, 0.0, mean, 0.0, stdDev, 0.0, 0.0);
        this.max = max < Math.exp(mean) ? Math.exp(mean) : max;
        this.mean = mean;
        this.stdDev = stdDev;
        this.BOUNDS = new Bounds(0.0, max, true);
        this.gaussian = Factory.distributionFactory().getGaussianDistribution(0.0, 1.0);
    }

    @Override
    public double trial() {
        double x = Math.exp(this.mean + this.gaussian.trial() * this.stdDev);
        while (x > this.max) {
            x = Math.exp(this.mean + this.gaussian.trial() * this.stdDev);
        }
        return x;
    }

    @Override
    public double getMax() {
        return this.max;
    }

    @Override
    public Bounds getBounds() {
        return this.BOUNDS;
    }

    public String toString() {
        return "Log-normal Distribution(" + this.getMean() + ", " + this.getStdDev() + ") limited to " + this.getMax();
    }
}

