/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.model.distributions;

import org.seamcat.model.distributions.AbstractDistribution;
import org.seamcat.model.distributions.DiscreteUniformDistribution;
import org.seamcat.model.distributions.UniformDistributionImpl;
import org.seamcat.model.functions.Bounds;

public class DiscreteUniformDistributionImpl
extends AbstractDistribution
implements DiscreteUniformDistribution {
    private final UniformDistributionImpl u = new UniformDistributionImpl(0.0, 1.0);
    private final Bounds bounds;

    public DiscreteUniformDistributionImpl(double min, double max, double step, double stepShift) {
        super(0.0, max, 0.0, 0.0, 0.0, min, 0.0, step, stepShift);
        this.bounds = new Bounds(min, max, true);
    }

    @Override
    public Bounds getBounds() {
        return this.bounds;
    }

    @Override
    public double trial() {
        int i;
        double rP = this.u.trial();
        double rMax = this.getMax();
        double rMin = this.getMin();
        double rStep = this.getStep();
        int n = (int)((rMax - rMin) / rStep);
        if (this.getStepShift() == 0.0) {
            ++n;
        }
        double rPi = 1.0 / (double)n;
        for (i = 0; i < n && rPi < rP; rPi += 1.0 / (double)n, ++i) {
        }
        return this.getStepShift() + rMin + (double)i * rStep;
    }

    public String toString() {
        return String.format("DiscreteUniformDistribution(%f, %f, %f)", this.getMin(), this.getMax(), this.getStep());
    }
}

