/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.model.antenna;

import org.apache.log4j.Logger;
import org.seamcat.model.antenna.HorizontalVerticalAntenna;
import org.seamcat.model.mathematics.Mathematics;
import org.seamcat.model.plugin.antenna.AntennaGainPlugin;
import org.seamcat.model.plugin.antenna.SphericalInput;
import org.seamcat.model.plugin.system.ConsistencyCheckContext;
import org.seamcat.model.simulation.consistency.Validator;
import org.seamcat.model.simulation.result.AntennaResult;
import org.seamcat.model.simulation.result.InterferenceLinkResult;
import org.seamcat.model.simulation.result.LinkResult;
import org.seamcat.model.types.Description;
import org.seamcat.model.types.result.DescriptionImpl;
import org.seamcat.simulation.generic.GenericSystemSimulation;

public class SphericalAntenna
implements AntennaGainPlugin<SphericalInput> {
    private static final Logger LOG = Logger.getLogger(HorizontalVerticalAntenna.class);

    @Override
    public void consistencyCheck(ConsistencyCheckContext context, SphericalInput input, Validator validator) {
        if (input.spherical().evaluateMax() > 0.0) {
            validator.error("<br/>The values of the antenna gain pattern must be relative to peak gain (i.e. &le 0 dB).");
        }
    }

    @Override
    public double evaluate(LinkResult context, AntennaResult antenna, double peakGain, SphericalInput input) {
        boolean compensationToConsider;
        double theta;
        double gain = 0.0;
        double phi = antenna.getAzimuth();
        double thetaH = theta = antenna.getElevation();
        double phiH = phi;
        double beta = -antenna.getTilt();
        double compensation = -antenna.getElevationCompensation();
        boolean bl = compensationToConsider = context instanceof InterferenceLinkResult && !Mathematics.equals(compensation, 0.0, 1.0E-5);
        if (!Mathematics.equals(antenna.getTilt(), 0.0, 1.0E-5) || compensationToConsider) {
            double tilt = beta;
            if (compensationToConsider) {
                tilt = GenericSystemSimulation.convertAngleToConfineToVerticalDefinedRange(beta + compensation);
            }
            theta = Mathematics.asinD(Mathematics.sinD(thetaH) * Mathematics.cosD(tilt) + Mathematics.cosD(thetaH) * Mathematics.cosD(antenna.getAzimuth()) * Mathematics.sinD(tilt));
            if (phiH > 180.0) {
                phiH = -360.0 + phiH;
            }
            phi = Mathematics.acosD(Math.min(1.0, Math.max(-1.0, (-Mathematics.sinD(thetaH) * Mathematics.sinD(tilt) + Mathematics.cosD(thetaH) * Mathematics.cosD(phiH) * Mathematics.cosD(tilt)) / Mathematics.cosD(theta))));
            phi = antenna.getAzimuth() > 180.0 ? 360.0 - phi : phi;
        }
        double sphericalAngle = Mathematics.acosD(Mathematics.cosD(theta) * Mathematics.cosD(phi));
        double sphericalGain = input.spherical().evaluate(sphericalAngle);
        gain = peakGain + sphericalGain;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Using spherical pattern");
            LOG.debug("Spherical angle (rSAng) = " + sphericalAngle + " = acosD(cosD(RxTXElev [" + theta + "]) * cosD(RxTxAzi [" + phi + "]))");
            LOG.debug("VrSResult = getVictimLinkReceiver().getAntenna().gainS(" + sphericalGain + ") = " + sphericalGain);
            LOG.debug("Antenna Gain = " + gain);
        }
        return gain;
    }

    @Override
    public Description description() {
        return new DescriptionImpl("Spherical Antenna", "The antenna gain is calculated using a spherical <br>antenna pattern");
    }
}

