/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.model.antenna;

import org.apache.log4j.Logger;
import org.seamcat.model.RadioSystem;
import org.seamcat.model.distributions.Distribution;
import org.seamcat.model.functions.Bounds;
import org.seamcat.model.mathematics.Mathematics;
import org.seamcat.model.plugin.antenna.AntennaGainPlugin;
import org.seamcat.model.plugin.antenna.ITU_R_F699Input;
import org.seamcat.model.plugin.system.ConsistencyCheckContext;
import org.seamcat.model.plugin.system.Origin;
import org.seamcat.model.simulation.consistency.Validator;
import org.seamcat.model.simulation.result.AntennaResult;
import org.seamcat.model.simulation.result.InterferenceLinkResult;
import org.seamcat.model.simulation.result.LinkResult;
import org.seamcat.model.types.Description;
import org.seamcat.model.types.Receiver;
import org.seamcat.model.types.Transmitter;
import org.seamcat.model.types.result.DescriptionImpl;
import org.seamcat.simulation.hybrid.HybridSystemPlugin;

public class ITU_R_F699
implements AntennaGainPlugin<ITU_R_F699Input> {
    private static final Logger LOG = Logger.getLogger(ITU_R_F699.class);

    @Override
    public double evaluate(LinkResult context, AntennaResult antennaResult, double peakGain, ITU_R_F699Input input) {
        double gain;
        double diameterToLambda;
        boolean compensationToConsider;
        double phiH = antennaResult.getAzimuth();
        double thetaH = antennaResult.getElevation();
        double theta = 0.0;
        double phi = 0.0;
        double beta = -antennaResult.getTilt();
        double compensation = -antennaResult.getElevationCompensation();
        boolean bl = compensationToConsider = context instanceof InterferenceLinkResult && !Mathematics.equals(compensation, 0.0, 1.0E-5);
        if (!Mathematics.equals(beta, 0.0, 1.0E-5) || compensationToConsider) {
            double tilt = beta;
            if (compensationToConsider) {
                tilt = this.convertAngleToConfineToVerticalDefinedRange(beta + compensation);
            }
            theta = Mathematics.asinD(Mathematics.sinD(thetaH) * Mathematics.cosD(tilt) + Mathematics.cosD(thetaH) * Mathematics.cosD(antennaResult.getAzimuth()) * Mathematics.sinD(tilt));
            if (phiH > 180.0) {
                phiH = -360.0 + phiH;
            }
            phi = Mathematics.acosD(Math.min(1.0, Math.max(-1.0, (-Mathematics.sinD(thetaH) * Mathematics.sinD(tilt) + Mathematics.cosD(thetaH) * Mathematics.cosD(phiH) * Mathematics.cosD(tilt)) / Mathematics.cosD(theta))));
            phi = antennaResult.getAzimuth() > 180.0 ? 360.0 - phi : phi;
        } else {
            theta = thetaH;
            phi = phiH;
        }
        double phiSpherical = Mathematics.acosD(Mathematics.cosD(theta) * Mathematics.cosD(phi));
        if (input.diameter().isRelevant()) {
            diameterToLambda = input.diameter().getValue() * context.getFrequency() / 300.0;
            peakGain = input.apertureEfficiency().isRelevant() ? 10.0 * Math.log10(input.apertureEfficiency().getValue() * Math.PI * Math.PI * diameterToLambda * diameterToLambda) : 7.7 + 20.0 * Math.log10(diameterToLambda);
        } else {
            diameterToLambda = Math.pow(10.0, (peakGain - 7.7) / 20.0);
        }
        double g1 = 2.0 + 15.0 * Math.log10(diameterToLambda);
        double phiM = 20.0 / diameterToLambda * Math.sqrt(peakGain - g1);
        double phiR = 15.85 * Math.pow(diameterToLambda, -0.6);
        if (context.getFrequency() < 1000.0) {
            double phiS = 144.5 * Math.pow(diameterToLambda, -0.2);
            gain = phiSpherical < phiM ? peakGain - 0.0025 * (diameterToLambda * phiSpherical) * (diameterToLambda * phiSpherical) : (phiSpherical < 100.0 / diameterToLambda ? g1 : (phiSpherical < phiS ? 52.0 - 10.0 * Math.log10(diameterToLambda) - 25.0 * Math.log10(phiSpherical) : -2.0 - 5.0 * Math.log10(diameterToLambda)));
        } else {
            gain = diameterToLambda > 100.0 ? (phiSpherical < phiM ? peakGain - 0.0025 * (diameterToLambda * phiSpherical) * (diameterToLambda * phiSpherical) : (phiSpherical < phiR ? g1 : (phiSpherical < 48.0 ? 32.0 - 25.0 * Math.log10(phiSpherical) : -10.0))) : (phiSpherical < phiM ? peakGain - 0.0025 * (diameterToLambda * phiSpherical) * (diameterToLambda * phiSpherical) : (phiSpherical < 100.0 / diameterToLambda ? g1 : (phiSpherical < 48.0 ? 52.0 - 10.0 * Math.log10(diameterToLambda) - 25.0 * Math.log10(phiSpherical) : 10.0 - 10.0 * Math.log10(diameterToLambda))));
        }
        if (LOG.isDebugEnabled()) {
            String msg = " ";
            msg = msg + (input.diameter().isRelevant() ? "Antenna diameter = " + input.diameter().getValue() + " m; " : "");
            msg = msg + (input.apertureEfficiency().isRelevant() ? "Aperture efficiency = " + input.apertureEfficiency().getValue() + " m; " : "");
            LOG.debug(msg);
        }
        return gain;
    }

    private double convertAngleToConfineToVerticalDefinedRange(double angle) {
        if (angle < -90.0) {
            return -(angle += 180.0);
        }
        if (angle > 90.0) {
            return -(angle -= 180.0);
        }
        if (Double.isNaN(angle)) {
            return 0.0;
        }
        return angle;
    }

    @Override
    public void consistencyCheck(ConsistencyCheckContext context, ITU_R_F699Input input, Validator validator) {
        Object element;
        if (context.getOrigin() == Origin.EPP) {
            return;
        }
        Distribution frequency = context.getFrequency();
        RadioSystem system = context.getSystem();
        Bounds freqRange = frequency.getBounds();
        if (freqRange.getMax() > 70000.0 || freqRange.getMin() < 100.0) {
            validator.error("Check Frequency: The antenna is designed for the frequency range 100 MHz to about 70 GHz.");
        }
        if ((element = context.getContextObject()) instanceof Receiver) {
            double hRX;
            double tGain = ((Receiver)element).getAntennaGain().peakGain();
            if (tGain < 10.0 && !input.diameter().isRelevant()) {
                validator.error("Check antenna gain: a peak gain less than 20 dBi seems unlikely for FS antennas");
            }
            if ((hRX = ((Receiver)element).getHeight().getBounds().getMin()) < 20.0) {
                validator.error("Check antenna height: it seems unlikely that the antenna is close to the street level");
            }
        } else if (element instanceof Transmitter) {
            double hTX;
            double tGain = ((Transmitter)element).getAntennaGain().peakGain();
            if (tGain < 15.0 && !input.diameter().isRelevant()) {
                validator.error("Check antenna gain: <b style = 'color:blue;'>a peak gain less than 15 dBi seems unlikely for FS antennas</b>");
            }
            if ((hTX = ((Transmitter)element).getHeight().getBounds().getMin()) < 20.0) {
                validator.error("Check antenna height: it seems unlikely that the antenna is close to the street level");
            }
        }
        if (input.diameter().isRelevant()) {
            if (input.diameter().getValue() < 0.1) {
                validator.error("Check antenna diameter: a diameter of less than 0.1 m seems too small");
            }
            if (input.apertureEfficiency().isRelevant()) {
                if (input.apertureEfficiency().getValue() < 0.35) {
                    validator.error("Check antenna aperture efficiency : the aperture efficiency should be at least 0.35");
                }
                if (input.apertureEfficiency().getValue() > 0.9) {
                    validator.error("Check antenna aperture efficiency: the aperture efficiency should be limited to 0.9");
                }
            }
        }
        if (context.getSystemPlugin() instanceof HybridSystemPlugin) {
            validator.error("This antenna is mainly for Fixed Service systems and therefore less suitable to Cellular Systems");
        }
    }

    @Override
    public Description description() {
        String s = "<HtMl>Rotationally symmetrical antenna for point-to-point LOS links <br/>in the frequency range 100 MHz ... 70 GHz. <br/><br/><p> <i>The frequency range 100 MHz ... 1 GHz is considered provisional for asymmetrical or non-aperture antennas. </i></p><br><i>You may move the cursor over the parameter names to get additional information</i></br>";
        return new DescriptionImpl("ITU-R F.699-7", s);
    }
}

