/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.model.antenna;

import org.apache.log4j.Logger;
import org.seamcat.model.RadioSystem;
import org.seamcat.model.distributions.ConstantDistribution;
import org.seamcat.model.distributions.Distribution;
import org.seamcat.model.functions.Bounds;
import org.seamcat.model.mathematics.Mathematics;
import org.seamcat.model.plugin.antenna.AntennaGainPlugin;
import org.seamcat.model.plugin.antenna.ITU_R_F1336_4_rec_3_Input;
import org.seamcat.model.plugin.antenna.TiltModes;
import org.seamcat.model.plugin.system.ConsistencyCheckContext;
import org.seamcat.model.plugin.system.Origin;
import org.seamcat.model.simulation.consistency.Validator;
import org.seamcat.model.simulation.result.AntennaResult;
import org.seamcat.model.simulation.result.InterferenceLinkResult;
import org.seamcat.model.simulation.result.LinkResult;
import org.seamcat.model.types.Description;
import org.seamcat.model.types.Receiver;
import org.seamcat.model.types.Transmitter;
import org.seamcat.model.types.result.DescriptionImpl;
import org.seamcat.simulation.generic.GenericSystemPlugin;
import org.seamcat.simulation.hybrid.HybridSystemPlugin;

public class ITU_R_F1336_4_rec_3
implements AntennaGainPlugin<ITU_R_F1336_4_rec_3_Input> {
    private static final Logger LOG = Logger.getLogger(ITU_R_F1336_4_rec_3.class);

    @Override
    public double evaluate(LinkResult context, AntennaResult antennaResult, double peakGain, ITU_R_F1336_4_rec_3_Input input) {
        double xk;
        double g180;
        double theta3;
        boolean compensationToConsider;
        double phi = 0.0;
        double theta = 0.0;
        double kp = input.kp();
        double ka = input.ka();
        double kh = input.kh();
        double kv = input.kv();
        double phiH = antennaResult.getAzimuth();
        double thetaH = antennaResult.getElevation();
        double phi3 = input.phi3();
        boolean directTheta3 = input.theta3().isRelevant();
        boolean calcMode = input.usePeakGain();
        double k = calcMode ? kp : ka;
        double beta = -antennaResult.getTilt();
        double compensation = -antennaResult.getElevationCompensation();
        boolean bl = compensationToConsider = context instanceof InterferenceLinkResult && !Mathematics.equals(compensation, 0.0, 1.0E-5);
        if (!Mathematics.equals(beta, 0.0, 1.0E-5) || compensationToConsider) {
            double tilt;
            if (phiH > 180.0) {
                phiH = -360.0 + phiH;
            }
            if (input.mAnde()) {
                tilt = beta;
                if (compensationToConsider) {
                    tilt = this.convertAngleToConfineToVerticalDefinedRange(beta + compensation);
                }
                theta = Mathematics.asinD(Mathematics.sinD(thetaH) * Mathematics.cosD(tilt) + Mathematics.cosD(thetaH) * Mathematics.cosD(antennaResult.getAzimuth()) * Mathematics.sinD(tilt));
                phi = Mathematics.acosD(Math.min(1.0, Math.max(-1.0, (-Mathematics.sinD(thetaH) * Mathematics.sinD(tilt) + Mathematics.cosD(thetaH) * Mathematics.cosD(phiH) * Mathematics.cosD(tilt)) / Mathematics.cosD(theta))));
                if (!Mathematics.equals(beta, 0.0, 1.0E-5)) {
                    thetaH = theta;
                    double additionalAngle = -input.additionalTilt().trial();
                    if (Mathematics.equals(Math.abs(additionalAngle), 90.0, 1.0E-5)) {
                        additionalAngle = additionalAngle < 0.0 ? (additionalAngle += 1.0E-4) : (additionalAngle -= 1.0E-4);
                    }
                    theta = thetaH + additionalAngle >= 0.0 ? 90.0 * (thetaH + additionalAngle) / (90.0 + additionalAngle) : 90.0 * (thetaH + additionalAngle) / (90.0 - additionalAngle);
                }
            } else if (input.tiltMode().equals((Object)TiltModes.ELECTRICAL_ONLY)) {
                if (Mathematics.equals(Math.abs(beta), 90.0, 1.0E-5)) {
                    beta = beta < 0.0 ? (beta += 1.0E-4) : (beta -= 1.0E-4);
                }
                theta = thetaH + beta >= 0.0 ? 90.0 * (thetaH + beta) / (90.0 + beta) : 90.0 * (thetaH + beta) / (90.0 - beta);
                phi = phiH;
                if (compensationToConsider) {
                    thetaH = theta;
                    theta = Mathematics.asinD(Mathematics.sinD(thetaH) * Mathematics.cosD(compensation) + Mathematics.cosD(thetaH) * Mathematics.cosD(antennaResult.getAzimuth()) * Mathematics.sinD(compensation));
                    phi = Mathematics.acosD(Math.min(1.0, Math.max(-1.0, (-Mathematics.sinD(thetaH) * Mathematics.sinD(compensation) + Mathematics.cosD(thetaH) * Mathematics.cosD(phiH) * Mathematics.cosD(compensation)) / Mathematics.cosD(theta))));
                }
            } else if (input.tiltMode().equals((Object)TiltModes.MECHANICAL_ONLY)) {
                tilt = beta;
                if (compensationToConsider) {
                    tilt = this.convertAngleToConfineToVerticalDefinedRange(beta + compensation);
                }
                theta = Mathematics.asinD(Mathematics.sinD(thetaH) * Mathematics.cosD(tilt) + Mathematics.cosD(thetaH) * Mathematics.cosD(antennaResult.getAzimuth()) * Mathematics.sinD(tilt));
                phi = Mathematics.acosD(Math.min(1.0, Math.max(-1.0, (-Mathematics.sinD(thetaH) * Mathematics.sinD(tilt) + Mathematics.cosD(thetaH) * Mathematics.cosD(phiH) * Mathematics.cosD(tilt)) / Mathematics.cosD(theta))));
            }
        } else {
            theta = thetaH;
            double d = phi = phiH > 180.0 ? -360.0 + phiH : phiH;
        }
        if (directTheta3) {
            theta3 = input.theta3().getValue();
            peakGain = phi3 >= 120.0 ? -10.0 * Math.log10(theta3 / 107.6) : -10.0 * Math.log10(theta3 * phi3 / 31000.0);
        } else {
            theta3 = phi3 < 120.0 ? 31000.0 * Math.pow(10.0, -0.1 * peakGain) / phi3 : 107.6 * Math.pow(10.0, -0.1 * peakGain);
        }
        double xh = Math.abs(phi / phi3);
        double xv = Math.abs(theta / theta3);
        double c = 10.0 * Math.log10(Math.pow(180.0 / theta3, 1.5) * (Math.pow(4.0, -1.5) + kv) / (1.0 + 8.0 * k)) / Math.log10(22.5 / theta3);
        double lkh = 3.0 * (1.0 - Math.pow(0.5, -kh));
        double lkv = 12.0 - c * Math.log10(4.0) - 10.0 * Math.log10(Math.pow(4.0, -1.5) + kv);
        if (calcMode) {
            g180 = -12.0 + 10.0 * Math.log10(1.0 + 8.0 * k) - 15.0 * Math.log10(180.0 / theta3);
            xk = Math.sqrt(1.0 - 0.36 * kv);
        } else {
            g180 = -15.0 + 10.0 * Math.log10(1.0 + 8.0 * k) - 15.0 * Math.log10(180.0 / theta3);
            xk = Math.sqrt(1.33 - 0.33 * kv);
        }
        double gHr180theta3 = this.calcGhr(180.0 / theta3, kh, lkh, g180);
        double r = (this.calcGhr(xh, kh, lkh, g180) - gHr180theta3) / (this.calcGhr(0.0, kh, lkh, g180) - gHr180theta3);
        double gain = peakGain + this.calcGhr(xh, kh, lkh, g180) + r * this.calcGvr(xv, kv, lkv, g180, xk, theta3, c, calcMode);
        return gain;
    }

    private double convertAngleToConfineToVerticalDefinedRange(double angle) {
        if (angle < -90.0) {
            return -(angle += 180.0);
        }
        if (angle > 90.0) {
            return -(angle -= 180.0);
        }
        if (Double.isNaN(angle)) {
            return 0.0;
        }
        return angle;
    }

    private double calcGhr(double xh, double kh, double lkh, double g180) {
        double ghr = xh <= 0.5 ? -12.0 * xh * xh : -12.0 * Math.pow(xh, 2.0 - kh) - lkh;
        return Math.max(ghr, g180);
    }

    private double calcGvr(double xv, double kv, double lkv, double g180, double xk, double theta3, double c, boolean calcMode) {
        double gvr = xv < xk ? -12.0 * xv * xv : (xv < 4.0 ? (calcMode ? -12.0 + 10.0 * Math.log10(Math.pow(xv, -1.5) + kv) : -15.0 + 10.0 * Math.log10(Math.pow(xv, -1.5) + kv)) : (xv < 90.0 / theta3 ? (calcMode ? -lkv - c * Math.log10(xv) : -lkv - 3.0 - c * Math.log10(xv)) : g180));
        return gvr;
    }

    @Override
    public Description description() {
        return new DescriptionImpl("ITU-R F.1336-4 rec 3", "<HtMl>clauses 3.1.1 (peak side-lobe performance) & 3.1.2 (average side-lobe performance)<br/><b>Please note that the additional electrical tilt is applicable only to an 'Antenna elevation'  not set equal to zero</b>.<br/><br><i>You may move the cursor over the parameter names to get additional information</i></br>");
    }

    @Override
    public void consistencyCheck(ConsistencyCheckContext context, ITU_R_F1336_4_rec_3_Input input, Validator validator) {
        double g;
        if (context.getOrigin() == Origin.EPP) {
            return;
        }
        Distribution frequency = context.getFrequency();
        double fmax = frequency.getBounds().getMax();
        double fmin = frequency.getBounds().getMin();
        double kp = input.kp();
        double kh = input.kh();
        double kv = input.kv();
        if (fmax > 6000.0 || fmin < 400.0) {
            validator.error("valid frequency range: 400 MHz ... 6 GHz");
        }
        if (context.getContextObject() instanceof Receiver) {
            g = ((Receiver)context.getContextObject()).getAntennaGain().peakGain();
            if (g < 1.0) {
                validator.error("Check value of peak gain, should not be equal to zero.");
            }
        } else if (context.getContextObject() instanceof Transmitter && (g = ((Transmitter)context.getContextObject()).getAntennaGain().peakGain()) < 1.0) {
            validator.error("Check value of peak gain, should not be equal to zero.");
        }
        if (input.ka() < 0.0 || input.ka() > 1.0) {
            validator.error("please check: 0\u2264ka\u22641");
        }
        if (kp < 0.0 || kp > 1.0) {
            validator.error("please check: 0\u2264kp\u22641");
        }
        if (kh < 0.0 || kh > 1.0) {
            validator.error("please check: 0\u2264kh\u22641");
        }
        if (kv < 0.0 || kv > 1.0) {
            validator.error("please check: 0\u2264kv\u22641");
        }
        if (input.mAnde()) {
            Bounds additional = input.additionalTilt().getBounds();
            if (additional.getMin() < -90.0 || additional.getMax() > 90.0) {
                validator.error("Elevation angles must be in the range -90 ... 90 degree");
            }
            double tilt = 100.0;
            String msg = "<HtMl><br/>You have specified an additional electrical tilt of " + input.additionalTilt() + " degrees.<br/>This value will be ignored due to the angle specified in 'Antenna elevation' is set to zero.";
            double constantAngle = 0.0;
            if (input.additionalTilt() instanceof ConstantDistribution) {
                constantAngle = ((ConstantDistribution)input.additionalTilt()).getConstant();
            }
            if (!(Mathematics.equals(constantAngle, 0.0, 0.001) && Mathematics.equals(additional.getMax(), additional.getMin(), 0.001) && Mathematics.equals(additional.getMax(), 0.0, 0.001))) {
                RadioSystem system = context.getSystem();
                if (context.getSystemPlugin() instanceof GenericSystemPlugin) {
                    GenericSystemPlugin plugin = (GenericSystemPlugin)context.getSystemPlugin();
                    if (context.getContextObject() instanceof Receiver) {
                        tilt = plugin.getRxPointing().getElevation().trial();
                    } else if (context.getContextObject() instanceof Transmitter) {
                        tilt = plugin.getTxPointing().getElevation().trial();
                    }
                } else if (context.getSystemPlugin() instanceof HybridSystemPlugin) {
                    HybridSystemPlugin plugin = (HybridSystemPlugin)context.getSystemPlugin();
                    tilt = plugin.getBs().getTilt().trial();
                    msg = "<HtMl><br/>You have specified an additional electrical tilt of " + input.additionalTilt() + " degrees.<br/>This value will be ignored due to the angle specified in 'Antenna tilt' is set to zero.";
                }
                if (Mathematics.equals(tilt, 0.0, 1.0E-5)) {
                    validator.error(msg);
                }
            }
        }
    }
}

