/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.model.antenna;

import org.seamcat.model.plugin.antenna.AntennaGainPlugin;
import org.seamcat.model.plugin.antenna.BeamFormingElementInput;
import org.seamcat.model.plugin.system.ConsistencyCheckContext;
import org.seamcat.model.simulation.consistency.Validator;
import org.seamcat.model.simulation.result.AntennaResult;
import org.seamcat.model.simulation.result.LinkResult;
import org.seamcat.model.types.Description;
import org.seamcat.model.types.result.DescriptionImpl;

public class BeamFormingElement
implements AntennaGainPlugin<BeamFormingElementInput> {
    @Override
    public Description description() {
        return new DescriptionImpl("Beam Forming Element Antenna", "");
    }

    @Override
    public void consistencyCheck(ConsistencyCheckContext context, BeamFormingElementInput input, Validator validator) {
    }

    @Override
    public double evaluate(LinkResult context, AntennaResult antenna, double peakGain, BeamFormingElementInput input) {
        double azimuth = antenna.getAzimuth() > 180.0 ? antenna.getAzimuth() - 360.0 : antenna.getAzimuth();
        double elevation = 90.0 - antenna.getElevation();
        double Aeh_dB = -Math.min(12.0 * Math.pow(azimuth / input.azimuthBeamwidth(), 2.0), input.frontBackRatio());
        double Aev_dB = -Math.min(12.0 * Math.pow((elevation - 90.0) / input.elevationBeamwidth(), 2.0), input.sideLobeLevelLimit());
        double gain = peakGain - Math.min(-1.0 * (Aeh_dB + Aev_dB), input.frontBackRatio());
        return gain;
    }
}

