/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.model.antenna;

import java.util.Locale;
import org.apache.log4j.Logger;
import org.seamcat.model.antenna.Complex;
import org.seamcat.model.factory.Factory;
import org.seamcat.model.functions.Function;
import org.seamcat.model.mathematics.Mathematics;
import org.seamcat.model.plugin.antenna.AntennaGainPlugin;
import org.seamcat.model.plugin.antenna.Antenna_3GPP_TR_37_840_Input;
import org.seamcat.model.plugin.system.ConsistencyCheckContext;
import org.seamcat.model.simulation.consistency.Validator;
import org.seamcat.model.simulation.result.AntennaResult;
import org.seamcat.model.simulation.result.InterferenceLinkResult;
import org.seamcat.model.simulation.result.LinkResult;
import org.seamcat.model.types.Description;
import org.seamcat.model.types.result.DescriptionImpl;
import org.seamcat.presentation.WarningColors;

public class Antenna_3GPP_TR_37_840
implements AntennaGainPlugin<Antenna_3GPP_TR_37_840_Input> {
    private static final Logger LOG = Logger.getLogger(Antenna_3GPP_TR_37_840.class);
    private final Locale formatLocate = new Locale("us");

    @Override
    public double evaluate(LinkResult context, AntennaResult antenna, double peakGain, Antenna_3GPP_TR_37_840_Input input) {
        if (input.specific() && (input.nh() < 1 || input.nv() < 1)) {
            return -1000.0;
        }
        double gain = 0.0;
        double correlationFactor = 1.0;
        AntennaResult antennaElementArray = Factory.results().antennaResult();
        AntennaResult antennaBeamForming = Factory.results().antennaResult();
        AntennaResult systemLinkAntenna = Factory.results().antennaResult();
        boolean systemIsInterferer = false;
        if (context instanceof InterferenceLinkResult) {
            antennaElementArray = antenna;
            InterferenceLinkResult iLink = (InterferenceLinkResult)context;
            if (context.txAntenna() == antenna) {
                systemLinkAntenna = iLink.getInterferingSystemLink().txAntenna();
                systemIsInterferer = true;
            } else if (context.rxAntenna() == antenna) {
                systemLinkAntenna = iLink.getVictimSystemLink().rxAntenna();
            }
            antennaBeamForming = systemLinkAntenna;
            if (!Mathematics.equals(systemLinkAntenna.getRandomPanelOffsetAzimuth(), 0.0, 0.001) || !Mathematics.equals(systemLinkAntenna.getRandomPanelOffsetElevation(), 0.0, 0.001)) {
                antennaBeamForming.setAzimuth(Mathematics.convertAngleToConfineToHorizontalDefinedRange(systemLinkAntenna.getRandomPanelOffsetAzimuth() - systemLinkAntenna.getAzimuth()));
                antennaBeamForming.setTilt(systemLinkAntenna.getRandomPanelOffsetElevation());
                antennaElementArray.setAzimuth(Mathematics.convertAngleToConfineToHorizontalDefinedRange(systemLinkAntenna.getRandomPanelOffsetAzimuth() - antenna.getAzimuth()));
                antennaElementArray.setTilt(systemLinkAntenna.getRandomPanelOffsetElevation());
            }
            antennaBeamForming = this.mechanicalTiltCorrection(antennaBeamForming);
            antennaElementArray = this.mechanicalTiltCorrection(antennaElementArray);
            if (systemIsInterferer) {
                correlationFactor = this.getCorrelationFactor(iLink, input.correlationFactor());
            }
        } else if (!Mathematics.equals(antenna.getRandomPanelOffsetAzimuth(), 0.0, 0.001) || !Mathematics.equals(antenna.getRandomPanelOffsetElevation(), 0.0, 0.001)) {
            systemLinkAntenna.setAzimuth(Mathematics.convertAngleToConfineToHorizontalDefinedRange(antenna.getRandomPanelOffsetAzimuth() - antenna.getAzimuth()));
            systemLinkAntenna.setElevation(antenna.getElevation());
            systemLinkAntenna.setTilt(antenna.getRandomPanelOffsetElevation());
            antennaBeamForming = this.mechanicalTiltCorrection(systemLinkAntenna);
            antennaElementArray.setAzimuth(antenna.getRandomPanelOffsetAzimuth());
            antennaElementArray.setElevation(antenna.getElevation());
            antennaElementArray.setTilt(antenna.getRandomPanelOffsetElevation());
            antennaElementArray = this.mechanicalTiltCorrection(antennaElementArray);
        } else {
            antennaElementArray = antennaBeamForming = this.mechanicalTiltCorrection(antenna);
        }
        Complex compositeSum = new Complex();
        Complex w = new Complex();
        Complex v = new Complex();
        int columns = input.specific() ? input.nh() : input.antennaType().getColumns();
        int rows = input.specific() ? input.nv() : input.antennaType().getElements();
        double w_weight = 1.0 / Math.sqrt(columns * rows);
        for (int m = 0; m < columns; ++m) {
            for (int n = 0; n < rows; ++n) {
                this.v(n, m, input, antennaElementArray, v);
                this.w(n, m, antennaBeamForming, input, w).scale(w_weight);
                compositeSum.add(w.multiply(v));
            }
        }
        double sum = Math.pow(compositeSum.abs(), 2.0);
        double correlated = 10.0 * Math.log10(1.0 + correlationFactor * (sum - 1.0));
        gain = input.specific() ? input.element().evaluate(context, antennaElementArray) : this.gainSingleElement(antennaElementArray, input);
        gain += correlated;
        if (LOG.isDebugEnabled()) {
            String info = systemIsInterferer ? String.format(this.formatLocate, "gain: %2.1f dBi; azimuth: %3.1f deg; elevation: %2.1f deg; tilt: %2.1f deg; correlation factor: %1.2f", gain, antenna.getAzimuth(), antenna.getElevation(), antenna.getTilt(), correlationFactor) : String.format(this.formatLocate, "gain: %2.1f dBi; azimuth: %3.1f deg; elevation: %2.1f deg; tilt: %2.1f deg", gain, antenna.getAzimuth(), antenna.getElevation(), antenna.getTilt());
            LOG.debug(info);
        }
        return gain;
    }

    private double getCorrelationFactor(InterferenceLinkResult iLink, Function function) {
        double bwTx;
        double bwRx;
        double vFrequency;
        double iFrequency = iLink.getFrequency();
        double offset = iFrequency - (vFrequency = iLink.getVictim().getLinkResult().getFrequency());
        if (offset > ((bwRx = iLink.getRxBandwidth()) + (bwTx = iLink.getInterferenceLink().getInterferer().getSystem().getTransmitter().getBandwidth())) / 2.0) {
            if (!function.getBounds().contains(offset)) {
                if (function.getBounds().contains(Math.abs(offset))) {
                    return function.evaluate(Math.abs(offset));
                }
                return function.evaluate(function.getBounds().getMax());
            }
            return function.evaluate(offset);
        }
        return 1.0;
    }

    private Complex w(int n, int m, AntennaResult antenna, Antenna_3GPP_TR_37_840_Input input, Complex result) {
        double azimuth = antenna.getAzimuth() > 180.0 ? antenna.getAzimuth() - 360.0 : antenna.getAzimuth();
        double elevation = antenna.getElevation();
        double vert = (double)n * this.verticalSpacing(input) * Mathematics.sinD(elevation);
        double hor = (double)m * this.horizontalSpacing(input) * Mathematics.cosD(elevation) * Mathematics.sinD(azimuth);
        double theta = Math.PI * 2 * (vert - hor);
        result.setReal(Math.cos(theta));
        result.setImaginary(Math.sin(theta));
        return result;
    }

    private double horizontalSpacing(Antenna_3GPP_TR_37_840_Input input) {
        if (input.specific()) {
            return input.horizontalSpacing();
        }
        return input.antennaType().getSpacingH();
    }

    private double verticalSpacing(Antenna_3GPP_TR_37_840_Input input) {
        if (input.specific()) {
            return input.verticalSpacing();
        }
        return input.antennaType().getSpacingV();
    }

    private Complex v(int n, int m, Antenna_3GPP_TR_37_840_Input input, AntennaResult antenna, Complex result) {
        double azimuthPointing = antenna.getAzimuth();
        double elevationPointing = 90.0 + antenna.getElevation();
        azimuthPointing = azimuthPointing > 180.0 ? azimuthPointing - 360.0 : azimuthPointing;
        double vert = (double)n * this.verticalSpacing(input) * Mathematics.cosD(elevationPointing);
        double hor = (double)m * this.horizontalSpacing(input) * Mathematics.sinD(elevationPointing) * Mathematics.sinD(azimuthPointing);
        double theta = Math.PI * 2 * (vert + hor);
        result.setReal(Math.cos(theta));
        result.setImaginary(Math.sin(theta));
        return result;
    }

    private double gainSingleElement(AntennaResult antenna, Antenna_3GPP_TR_37_840_Input input) {
        double azimuth = antenna.getAzimuth() > 180.0 ? antenna.getAzimuth() - 360.0 : antenna.getAzimuth();
        double elevation = antenna.getElevation();
        double front_to_back = 30.0;
        double side_lobe = 30.0;
        double Aeh_dB = -Math.min(12.0 * Math.pow(azimuth / input.antennaType().getBeamWidthH(), 2.0), front_to_back);
        Aeh_dB = 12.0 * azimuth / input.antennaType().getBeamWidthH() * azimuth / input.antennaType().getBeamWidthH();
        Aeh_dB = -Math.min(Aeh_dB, front_to_back);
        double Aev_dB = -Math.min(12.0 * Math.pow(elevation / input.antennaType().getBeamWidthV(), 2.0), side_lobe);
        Aev_dB = 12.0 * elevation / input.antennaType().getBeamWidthV() * elevation / input.antennaType().getBeamWidthV();
        Aev_dB = -Math.min(Aev_dB, side_lobe);
        double s = -(Aeh_dB + Aev_dB);
        double gain = input.antennaType().gainSingleElement() - Math.min(-1.0 * (Aeh_dB + Aev_dB), front_to_back);
        return gain;
    }

    private double cableLoss(Antenna_3GPP_TR_37_840_Input input) {
        return input.antennaType().getCableLoss();
    }

    @Override
    public void consistencyCheck(ConsistencyCheckContext context, Antenna_3GPP_TR_37_840_Input input, Validator validator) {
        String msg = "";
        if (input.specific()) {
            double gainSingle;
            if (input.nh() < 1) {
                msg = "The number of columns must not be set to &le 0.";
            }
            if (input.nv() < 1) {
                if (!msg.isEmpty()) {
                    msg = msg + "<br>";
                }
                msg = msg + "The number of radiation elements per column must not be set to &le 0.";
            }
            if (!msg.isEmpty()) {
                msg = msg + "<p " + (Object)((Object)WarningColors.MASK_WARNING) + ">Ignoring this will set the antenna gain to -1000 dBi</p>";
                validator.error(msg);
            }
            if (!Mathematics.equals(gainSingle = input.element().peakGain(), 6.5, 1.5)) {
                if (input.nv() * input.nh() < 10) {
                    msg = String.format(this.formatLocate, "<br>A peak gain of %2.1f dBi of the single element antenna might not fit the antenna specification.<p " + (Object)((Object)WarningColors.ACCURARY_WARNING) + ">A value of 8.0 dBi seems rather suitable.</p>", gainSingle);
                    validator.error(msg);
                } else {
                    msg = String.format(this.formatLocate, "<br>A peak gain of %2.1f dBi of the single element antenna might not fit the antenna specification.<p " + (Object)((Object)WarningColors.ACCURARY_WARNING) + ">A value of 6.5 dBi seems rather suitable.</p>", gainSingle);
                    validator.error(msg);
                }
            }
            if (input.horizontalSpacing() < 0.5 || input.horizontalSpacing() > 0.95) {
                msg = String.format(this.formatLocate, "<br>A horizontal radiating element spacing d/&lambda = %2.1f might cause inaccuracies.<p " + (Object)((Object)WarningColors.ACCURARY_WARNING) + ">The value should be in the range 0.5 ... 0.9 (depending on the frequencies simulated).</p>", input.horizontalSpacing());
                validator.error(msg);
            }
            if (input.verticalSpacing() < 0.5 || input.verticalSpacing() > 0.95) {
                msg = String.format(this.formatLocate, "<br>A vertical radiating element spacing d/&lambda = %2.1f might cause inaccuracies.<p " + (Object)((Object)WarningColors.ACCURARY_WARNING) + ">The value should be in the range 0.5 ... 0.9 (depending on the frequencies simulated).</p>", input.verticalSpacing());
                validator.error(msg);
            }
        }
        if (input.correlationFactor().evaluateMax() > 1.0 || input.correlationFactor().evaluateMin() < 0.0) {
            msg = input.correlationFactor().isConstant() ? String.format(this.formatLocate, "The valid range of the correlation factor &rho is 0 ... 1, but currently set to %2.1f.<p " + (Object)((Object)WarningColors.ACCURARY_WARNING) + ">The will cause wrong antenna gain results.", input.correlationFactor().evaluateMax()) : String.format(this.formatLocate, "The valid range of the correlation factor &rho is 0 ... 1, but currently set to (%2.1f,%2.1f).<p " + (Object)((Object)WarningColors.ACCURARY_WARNING) + ">The will cause wrong antenna gain results.", input.correlationFactor().evaluateMin(), input.correlationFactor().evaluateMax());
            validator.error(msg);
        }
    }

    private AntennaResult mechanicalTiltCorrection(AntennaResult antenna) {
        if (Mathematics.equals(antenna.getTilt(), 0.0, 0.001)) {
            return antenna;
        }
        AntennaResult res = Factory.results().antennaResult();
        double phiH = antenna.getAzimuth();
        double thetaH = -antenna.getElevation();
        double tilt = -antenna.getTilt();
        double theta = Mathematics.asinD(Mathematics.sinD(thetaH) * Mathematics.cosD(tilt) + Mathematics.cosD(thetaH) * Mathematics.cosD(antenna.getAzimuth()) * Mathematics.sinD(tilt));
        if (phiH > 180.0) {
            phiH = -360.0 + phiH;
        }
        double phi = Mathematics.acosD(Math.min(1.0, Math.max(-1.0, (-Mathematics.sinD(thetaH) * Mathematics.sinD(tilt) + Mathematics.cosD(thetaH) * Mathematics.cosD(phiH) * Mathematics.cosD(tilt)) / Mathematics.cosD(theta))));
        phi = antenna.getAzimuth() > 180.0 ? 360.0 - phi : phi;
        res.setTilt(antenna.getTilt());
        res.setAzimuth(phi);
        res.setElevation(theta);
        res.setAzimuthCompensation(antenna.getAzimuthCompensation());
        res.setElevationCompensation(antenna.getElevationCompensation());
        return res;
    }

    @Override
    public Description description() {
        return new DescriptionImpl("3GPP TR 37.840", "according to 3GPP TR 37.840 V12.1.0 (2013-12)");
    }
}

