/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.model.antenna;

import java.util.Locale;
import org.apache.log4j.Logger;
import org.seamcat.model.factory.Factory;
import org.seamcat.model.mathematics.Mathematics;
import org.seamcat.model.plugin.antenna.AntennaGainPlugin;
import org.seamcat.model.plugin.antenna.Antenna_3GPP_TR_36_814_Input;
import org.seamcat.model.plugin.system.ConsistencyCheckContext;
import org.seamcat.model.simulation.consistency.Validator;
import org.seamcat.model.simulation.result.AntennaResult;
import org.seamcat.model.simulation.result.InterferenceLinkResult;
import org.seamcat.model.simulation.result.LinkResult;
import org.seamcat.model.types.Description;
import org.seamcat.model.types.result.DescriptionImpl;

public class Antenna_3GPP_TR_36_814
implements AntennaGainPlugin<Antenna_3GPP_TR_36_814_Input> {
    private static final Logger LOG = Logger.getLogger(Antenna_3GPP_TR_36_814.class);
    private final Locale formatLocate = new Locale("us");

    @Override
    public double evaluate(LinkResult context, AntennaResult antenna, double peakGain, Antenna_3GPP_TR_36_814_Input input) {
        boolean considerTiltCorrection;
        boolean horizontal = input.planes() == Antenna_3GPP_TR_36_814_Input.Planes.BOTH || input.planes() == Antenna_3GPP_TR_36_814_Input.Planes.HORIZONTAL;
        boolean vertical = input.planes() == Antenna_3GPP_TR_36_814_Input.Planes.BOTH || input.planes() == Antenna_3GPP_TR_36_814_Input.Planes.VERTICAL;
        double eTilt = input.electricalTilt().trial();
        double aH = -25.0;
        double aV = -20.0;
        double gain = -20.0;
        double mTilt = -antenna.getTilt();
        double phi = antenna.getAzimuth();
        double theta = antenna.getElevation();
        boolean bl = considerTiltCorrection = !Mathematics.equals(mTilt, 0.0, 0.001) || context instanceof InterferenceLinkResult && !Mathematics.equals(antenna.getElevationCompensation(), 0.0, 0.001);
        if (considerTiltCorrection) {
            AntennaResult antennaCorrected = Factory.results().antennaResult();
            double beta = Mathematics.convertAngleToConfineToVerticalDefinedRange(mTilt + antenna.getElevationCompensation());
            antennaCorrected.setAzimuth(phi);
            antennaCorrected.setElevation(theta);
            antennaCorrected.setTilt(beta);
            antennaCorrected = this.mechanicalTiltCorrection(antennaCorrected);
            phi = antennaCorrected.getAzimuth();
            theta = antennaCorrected.getElevation();
        }
        if (phi > 180.0) {
            phi -= 360.0;
        }
        if (horizontal) {
            gain = aH = -Math.min(12.0 * (phi / 70.0) * (phi / 70.0), 25.0);
        }
        if (vertical) {
            gain = aV = -Math.min(12.0 * (theta - eTilt) * (theta - eTilt) * 0.01, 20.0);
        }
        if (horizontal && vertical) {
            gain = -Math.min(-1.0 * (aH + aV), 25.0);
        }
        if (LOG.isDebugEnabled()) {
            String info = String.format(this.formatLocate, "gain: %2.1f dBi; azimuth: %3.1f deg; elevation: %2.1f deg; mechanical tilt: %2.1f deg; electrical tilt: %2.1f deg", peakGain + gain, phi, theta, mTilt, eTilt);
            LOG.debug(info);
        }
        return peakGain + gain;
    }

    @Override
    public void consistencyCheck(ConsistencyCheckContext context, Antenna_3GPP_TR_36_814_Input input, Validator validator) {
    }

    @Override
    public Description description() {
        return new DescriptionImpl("3GPP TR 36.814", "according to 3GPP TR 36.814 V9.2.0 (2017-03) ");
    }

    private AntennaResult mechanicalTiltCorrection(AntennaResult antenna) {
        if (Mathematics.equals(antenna.getTilt(), 0.0, 0.001)) {
            return antenna;
        }
        AntennaResult res = Factory.results().antennaResult();
        double phiH = antenna.getAzimuth();
        double thetaH = antenna.getElevation();
        double tilt = antenna.getTilt();
        double theta = Mathematics.asinD(Mathematics.sinD(thetaH) * Mathematics.cosD(tilt) + Mathematics.cosD(thetaH) * Mathematics.cosD(antenna.getAzimuth()) * Mathematics.sinD(tilt));
        if (phiH > 180.0) {
            phiH = -360.0 + phiH;
        }
        double phi = Mathematics.acosD(Math.min(1.0, Math.max(-1.0, (-Mathematics.sinD(thetaH) * Mathematics.sinD(tilt) + Mathematics.cosD(thetaH) * Mathematics.cosD(phiH) * Mathematics.cosD(tilt)) / Mathematics.cosD(theta))));
        phi = antenna.getAzimuth() > 180.0 ? 360.0 - phi : phi;
        res.setTilt(tilt);
        res.setAzimuth(phi);
        res.setElevation(theta);
        res.setAzimuthCompensation(antenna.getAzimuthCompensation());
        res.setElevationCompensation(antenna.getElevationCompensation());
        return res;
    }
}

