/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.model.antenna;

import org.seamcat.model.functions.Function;
import org.seamcat.model.plugin.Config;

public interface APmanufacturerDataInput {
    public static final double peakGain = 15.65;

    @Config(order=1, name="Installation of the antenna", toolTip="In case vertically mounted the vertical pattern are used as horizontal pattern.")
    public AntennaMounted mounted();

    @Config(order=5, name="Specified angle range", unit="deg", toolTip="Applies to both pattern")
    public AngleRange angleRange();

    @Config(order=10, name="Horizontal pattern", toolTip="counted CCW from 0 to 180 deg and CE from 0 to -180 deg")
    public Function horizontalPattern();

    @Config(order=15, name="Vertical pattern")
    public Function verticalPattern();

    public static enum Manufacturer {
        KATHREIN("Kathrein"),
        PROCON("Procon"),
        OTHER("search file");

        String name;

        private Manufacturer(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }

    public static enum AntennaMounted {
        Horizontal("Antenna is mounted horizontally"),
        Vertical("Antenna is mounted vertically");

        String name;

        private AntennaMounted(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }

    public static enum AngleRange {
        From180To180("Angle range -180 ... 180 deg "),
        From0To360("Angle range 0 ... 360 deg");

        String name;

        private AngleRange(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

