/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.migration.workspace;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.xml.namespace.QName;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import org.seamcat.migration.FormatVersion;
import org.seamcat.migration.IOUtils;
import org.seamcat.migration.MigrationException;
import org.seamcat.migration.VersionExtractor;
import org.seamcat.migration.workspace.WorkspaceFormatVersionConstants;

public class WorkspaceVersionExtractor
extends VersionExtractor {
    @Override
    public FormatVersion extractVersion(File file) {
        VersionExtractor.FileType fileType = this.determineFileType(file);
        switch (fileType) {
            case XML_FILE: {
                return this.extractVersionFromXmlWorkspaceFile(file);
            }
            case ZIP_FILE: {
                return this.extractVersionFromZippedWorkspaceFile(file);
            }
        }
        throw new MigrationException("File type " + (Object)((Object)fileType) + " not supported for " + file);
    }

    private FormatVersion extractVersionFromXmlWorkspaceFile(File file) {
        try {
            return this.extractVersionFromScenarioDocumentInputStream(new BufferedInputStream(new FileInputStream(file)));
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    private FormatVersion extractVersionFromScenarioDocumentInputStream(InputStream inputStream) {
        WorkspaceVersionAttributes versionAttributes = this.extractVersionAttributesFromScenarioDocument(inputStream);
        if (versionAttributes.formatVersion != null) {
            return new FormatVersion(Integer.parseInt(versionAttributes.formatVersion));
        }
        if (versionAttributes.seamcatVersion != null && !WorkspaceVersionExtractor.isPre323SeamcatVersionString(versionAttributes.seamcatVersion)) {
            return WorkspaceFormatVersionConstants.POST_3_2_3;
        }
        if (versionAttributes.seamcatVersion != null && WorkspaceVersionExtractor.isPre323SeamcatVersionString(versionAttributes.seamcatVersion)) {
            return WorkspaceFormatVersionConstants.PRE_3_2_3;
        }
        return WorkspaceFormatVersionConstants.PREHISTORIC;
    }

    private WorkspaceVersionAttributes extractVersionAttributesFromScenarioDocument(InputStream inputStream) {
        try {
            return this.tryExtractVersionAttributesFromScenarioDocument(inputStream);
        }
        catch (XMLStreamException e) {
            throw new MigrationException(e);
        }
        catch (FactoryConfigurationError e) {
            throw new MigrationException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private WorkspaceVersionAttributes tryExtractVersionAttributesFromScenarioDocument(InputStream inputStream) throws XMLStreamException, FactoryConfigurationError {
        XMLEventReader eventReader = null;
        try {
            eventReader = XMLInputFactory.newFactory().createXMLEventReader(inputStream);
            while (eventReader.peek() != null && !eventReader.peek().isStartElement()) {
                eventReader.next();
            }
            if (eventReader.peek() == null) {
                throw new MigrationException("Document element not found");
            }
            StartElement documentElement = eventReader.peek().asStartElement();
            WorkspaceVersionAttributes result = new WorkspaceVersionAttributes();
            Attribute workspaceFormatVersionAttribute = documentElement.getAttributeByName(new QName("workspace_format_version"));
            result.formatVersion = workspaceFormatVersionAttribute != null ? workspaceFormatVersionAttribute.getValue() : null;
            Attribute seamcatVersionAttribute = documentElement.getAttributeByName(new QName("seamcat_version"));
            result.seamcatVersion = seamcatVersionAttribute != null ? seamcatVersionAttribute.getValue() : null;
            WorkspaceVersionAttributes workspaceVersionAttributes = result;
            return workspaceVersionAttributes;
        }
        finally {
            IOUtils.closeQuietly(eventReader);
        }
    }

    public static boolean isPre323SeamcatVersionString(String versionString) {
        String[] versions = versionString.split(" ");
        boolean foundRevision = false;
        for (String sub : versions) {
            if (!sub.equals("rev")) continue;
            foundRevision = true;
        }
        try {
            int parseInt;
            int i;
            String[] version;
            if (foundRevision) {
                int revision = Integer.parseInt(versions[versions.length - 1]);
                if (revision <= 938) {
                    return true;
                }
            } else if (versions.length >= 2) {
                version = versions[1].split("[.]");
                for (i = 0; i < version.length; ++i) {
                    parseInt = Integer.parseInt(version[i]);
                    if (i == 0 && parseInt < 3) {
                        return true;
                    }
                    if (i == 1 && parseInt < 2) {
                        return true;
                    }
                    if (i != 2 || parseInt >= 3) continue;
                    return true;
                }
            } else {
                version = versions[0].split("[.]");
                for (i = 0; i < version.length; ++i) {
                    parseInt = Integer.parseInt(version[i]);
                    if (i == 0 && parseInt < 3) {
                        return true;
                    }
                    if (i == 1 && parseInt < 2) {
                        return true;
                    }
                    if (i != 2 || parseInt >= 3) continue;
                    return true;
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return false;
    }

    private FormatVersion extractVersionFromZippedWorkspaceFile(File file) {
        FormatVersion formatVersion;
        ZipFile zipFile = null;
        try {
            zipFile = new ZipFile(file);
            ZipEntry scenarioEntry = zipFile.getEntry("scenario.xml");
            if (scenarioEntry == null) {
                throw new MigrationException("Scenario entry not found in workspace zip file");
            }
            InputStream scenarioInputStream = zipFile.getInputStream(scenarioEntry);
            formatVersion = this.extractVersionFromScenarioDocumentInputStream(scenarioInputStream);
        }
        catch (Exception e) {
            try {
                throw new MigrationException("Failed extracting version from workspace zip file: " + file, e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(zipFile);
                throw throwable;
            }
        }
        IOUtils.closeQuietly(zipFile);
        return formatVersion;
    }

    private static class WorkspaceVersionAttributes {
        String formatVersion;
        String seamcatVersion;

        private WorkspaceVersionAttributes() {
        }
    }
}

