/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.migration.workspace;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.jxpath.JXPathContext;
import org.seamcat.migration.FormatVersion;
import org.seamcat.migration.workspace.AbstractScenarioMigration;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Rule065PowerDistributionIMT2020DLWorkspaceMigration
extends AbstractScenarioMigration {
    @Override
    public void migrateScenarioDocument(Document document) {
        JXPathContext context = JXPathContext.newContext(document);
        Rule065PowerDistributionIMT2020DLWorkspaceMigration.fixSystemElements(context, document);
        this.updateVersion(document);
    }

    public static void fixSystemElements(JXPathContext context, Document document) {
        ArrayList<Element> imtDLElements = new ArrayList<Element>();
        List systems = context.selectNodes("//systems/system");
        for (Object obj : systems) {
            Element system = (Element)obj;
            String classname = system.getAttribute("classname");
            String location = system.getAttribute("location");
            if (!location.equals("BUILT-IN") || !classname.equals("org.seamcat.model.systems.imt2020downlink.IMT2020DownLinkSystemPlugin") && !classname.equals("org.seamcat.model.systems.imt2020downlink.IMT2020DownLinkMicroSystemPlugin")) continue;
            imtDLElements.add(system);
        }
        for (Element imtDLElement : imtDLElements) {
            JXPathContext pathContext = JXPathContext.newContext(imtDLElement);
            Element tx = (Element)pathContext.selectSingleNode("//transmitterSettings");
            String max = tx.getAttribute("bsMaximumTransmitPower");
            tx.removeAttribute("bsMaximumTransmitPower");
            Element distribution = document.createElement("distribution");
            distribution.setAttribute("type", "0");
            distribution.setAttribute("constant", max);
            Element power = document.createElement("bsTransmitPower");
            power.appendChild(distribution);
            tx.appendChild(power);
        }
    }

    @Override
    void migrateResultsDocument(Document document) {
    }

    private void updateVersion(Document document) {
        JXPathContext context = JXPathContext.newContext(document);
        context.createPathAndSetValue("Workspace/@workspace_format_version", this.getOriginalVersion().nextVersion().getNumber());
    }

    @Override
    public FormatVersion getOriginalVersion() {
        return new FormatVersion(64);
    }
}

