/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.migration.workspace;

import java.util.List;
import org.apache.commons.jxpath.JXPathContext;
import org.seamcat.migration.FormatVersion;
import org.seamcat.migration.workspace.AbstractScenarioMigration;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Rule062OFDMAUpLinkNonFullyLoadedWorkspaceMigration
extends AbstractScenarioMigration {
    @Override
    public void migrateScenarioDocument(Document document) {
        JXPathContext context = JXPathContext.newContext(document);
        List systems = context.selectNodes("//system");
        for (Object system : systems) {
            Element element = (Element)system;
            element.setAttribute("location", "BUILT-IN");
            String classname = element.getAttribute("classname");
            if (!classname.equals("org.seamcat.simulation.hybrid.HybridOFDMAUpLinkPlugin")) continue;
            NodeList nodes = element.getChildNodes();
            for (int i = 0; i < nodes.getLength(); ++i) {
                Node item = nodes.item(i);
                if (!(item instanceof Element) || !item.getNodeName().equals("generalSettings")) continue;
                Element gs = (Element)item;
                Element generalSettings = (Element)gs.getElementsByTagName("generalSettings").item(0);
                int maxBs = Integer.parseInt(generalSettings.getAttribute("maxSubcarriersBs"));
                int maxMs = Integer.parseInt(generalSettings.getAttribute("maxSubcarriersMs"));
                int ratio = (int)Math.floor((double)maxBs / (double)maxMs);
                Element ueDistribution = document.createElement("ueDistribution");
                ueDistribution.setAttribute("numberOfActiveMsPerBs", Integer.toString(ratio));
                Element probabilities = document.createElement("probabilities");
                double avg = 100.0 / (double)ratio;
                for (int c = 0; c < ratio; ++c) {
                    Element ii = document.createElement("item");
                    ii.setAttribute("item", Double.toString(avg));
                    probabilities.appendChild(ii);
                }
                ueDistribution.appendChild(probabilities);
                gs.appendChild(ueDistribution);
            }
        }
        this.updateVersion(document);
    }

    @Override
    void migrateResultsDocument(Document document) {
    }

    private void updateVersion(Document document) {
        JXPathContext context = JXPathContext.newContext(document);
        context.createPathAndSetValue("Workspace/@workspace_format_version", this.getOriginalVersion().nextVersion().getNumber());
    }

    @Override
    public FormatVersion getOriginalVersion() {
        return new FormatVersion(61);
    }
}

