/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.migration.workspace;

import java.util.List;
import org.apache.commons.jxpath.JXPathContext;
import org.seamcat.migration.FormatVersion;
import org.seamcat.migration.workspace.AbstractScenarioMigration;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Rule061SystemPluginWorkspaceMigration
extends AbstractScenarioMigration {
    @Override
    public void migrateScenarioDocument(Document document) {
        JXPathContext context = JXPathContext.newContext(document);
        List systems = context.selectNodes("//system");
        for (Object system : systems) {
            Element element = (Element)system;
            element.setAttribute("location", "BUILT-IN");
            String aClass = element.getAttribute("class");
            element.removeAttribute("class");
            String pluginClass = null;
            switch (aClass) {
                case "org.seamcat.model.systems.generic.SystemModelGeneric": {
                    pluginClass = "org.seamcat.simulation.generic.GenericSystemPlugin";
                    break;
                }
                case "org.seamcat.model.systems.cdma.SystemModelCDMAUpLink": {
                    pluginClass = "org.seamcat.simulation.hybrid.HybridCDMAUpLinkPlugin";
                    break;
                }
                case "org.seamcat.model.systems.cdma.SystemModelCDMADownLink": {
                    pluginClass = "org.seamcat.simulation.hybrid.HybridCDMADownLinkPlugin";
                    break;
                }
                case "org.seamcat.model.systems.ofdma.SystemModelOFDMAUpLink": {
                    pluginClass = "org.seamcat.simulation.hybrid.HybridOFDMAUpLinkPlugin";
                    break;
                }
                case "org.seamcat.model.systems.ofdma.SystemModelOFDMADownLink": {
                    pluginClass = "org.seamcat.simulation.hybrid.HybridOFDMADownLinkPlugin";
                }
            }
            element.setAttribute("classname", pluginClass);
        }
        this.updateVersion(document);
    }

    @Override
    void migrateResultsDocument(Document document) {
    }

    private void updateVersion(Document document) {
        JXPathContext context = JXPathContext.newContext(document);
        context.createPathAndSetValue("Workspace/@workspace_format_version", this.getOriginalVersion().nextVersion().getNumber());
    }

    @Override
    public FormatVersion getOriginalVersion() {
        return new FormatVersion(60);
    }
}

