/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.migration.workspace;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.jxpath.JXPathContext;
import org.seamcat.migration.FormatVersion;
import org.seamcat.migration.workspace.AbstractScenarioMigration;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class Rule053CompositeMarshallerWorkspaceMigration
extends AbstractScenarioMigration {
    @Override
    public void migrateScenarioDocument(Document document) {
        JXPathContext context = JXPathContext.newContext(document);
        List cList = context.selectNodes("//composite");
        ArrayList<Element> destructive = new ArrayList<Element>();
        for (Object o : cList) {
            Element composite = (Element)o;
            Node parent = composite.getParentNode();
            String name = parent.getNodeName();
            if (name.equals("system")) {
                destructive.add(composite);
                continue;
            }
            while (composite.hasChildNodes()) {
                Node child = composite.getFirstChild();
                composite.removeChild(child);
                parent.appendChild(child);
            }
            parent.removeChild(composite);
        }
        for (Element composite : destructive) {
            Element system = (Element)composite.getParentNode();
            system.setAttribute("class", composite.getAttribute("class"));
            while (composite.hasChildNodes()) {
                Node child = composite.getFirstChild();
                composite.removeChild(child);
                system.appendChild(child);
            }
            system.removeChild(composite);
        }
        this.updateVersion(document);
    }

    @Override
    void migrateResultsDocument(Document document) {
    }

    private void updateVersion(Document document) {
        JXPathContext context = JXPathContext.newContext(document);
        context.createPathAndSetValue("Workspace/@workspace_format_version", this.getOriginalVersion().nextVersion().getNumber());
    }

    @Override
    public FormatVersion getOriginalVersion() {
        return new FormatVersion(52);
    }
}

