/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.migration.workspace;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.jxpath.JXPathContext;
import org.seamcat.migration.FormatVersion;
import org.seamcat.migration.workspace.AbstractScenarioMigration;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Rule052TrafficAndCorrelationModeWorkspaceMigration
extends AbstractScenarioMigration {
    private Map<String, Element> genericSystems = new HashMap<String, Element>();
    private List<String> processed = new ArrayList<String>();

    @Override
    public void migrateScenarioDocument(Document document) {
        JXPathContext context = JXPathContext.newContext(document);
        List syss = context.selectNodes("//system/composite");
        for (Object sys : syss) {
            Element element = (Element)sys;
            if (!element.getAttribute("class").equals("org.seamcat.model.systems.generic.SystemModelGeneric")) continue;
            String id = ((Element)element.getParentNode()).getAttribute("id");
            this.genericSystems.put(id, element);
        }
        List cls = context.selectNodes("//links/link/composite/path/composite/correlationSettings");
        block1: for (Object e : cls) {
            Element corr = (Element)e;
            int mode = Integer.parseInt(corr.getAttribute("mode"));
            String classname = mode == 0 ? "org.seamcat.model.correlation.NoneMode" : (mode == 1 ? "org.seamcat.simulation.generic.UniformMode" : (mode == 2 ? "org.seamcat.simulation.generic.ClosestMode" : "org.seamcat.model.correlation.Correlated"));
            corr.removeAttribute("mode");
            corr.setAttribute("mode", classname);
            corr.setAttribute("mode_index", "0");
            String target = corr.getAttribute("correlationTarget");
            if (target.equals("ILTx")) {
                corr.removeAttribute("correlationTarget");
                corr.setAttribute("correlationTarget", "ILT");
            } else if (target.equals("ILRx")) {
                corr.removeAttribute("correlationTarget");
                corr.setAttribute("correlationTarget", "ILR");
            }
            String relativeTo = corr.getAttribute("positionRelativeTo");
            if (relativeTo.equals("VLRx")) {
                corr.removeAttribute("positionRelativeTo");
                corr.setAttribute("positionRelativeTo", "VLR");
            } else if (relativeTo.equals("VLTx")) {
                corr.removeAttribute("positionRelativeTo");
                corr.setAttribute("positionRelativeTo", "VLT");
            }
            if (mode != 1 && mode != 2) continue;
            NodeList items = corr.getElementsByTagName("customItem");
            for (int i = 0; i < items.getLength(); ++i) {
                Element item = (Element)items.item(i);
                if (!item.getAttribute("classname").equals("org.seamcat.model.generic.InterferersDensityUI")) continue;
                Element link = (Element)corr.getParentNode().getParentNode().getParentNode().getParentNode();
                String id = link.getAttribute("interferingSystemId");
                Element system = this.genericSystems.get(id);
                JXPathContext sysContext = JXPathContext.newContext(context, system);
                Element path = (Element)sysContext.selectSingleNode("//path/composite");
                Element density = document.createElement("transmitterDensity");
                density.setAttribute("densityTx", item.getAttribute("densityTx"));
                density.setAttribute("hourOfDay", item.getAttribute("hourOfDay"));
                density.setAttribute("probabilityOfTransmission", item.getAttribute("probabilityOfTransmission"));
                Node child = item.getFirstChild();
                item.removeChild(child);
                density.appendChild(child);
                path.appendChild(density);
                this.processed.add(id);
                item.getParentNode().removeChild(item);
                continue block1;
            }
        }
        for (Map.Entry entry : this.genericSystems.entrySet()) {
            if (this.processed.contains(entry.getKey())) continue;
            Element system = (Element)entry.getValue();
            JXPathContext sysContext = JXPathContext.newContext(context, system);
            Element path = (Element)sysContext.selectSingleNode("//path/composite");
            path.appendChild(Rule052TrafficAndCorrelationModeWorkspaceMigration.getDefaultDensity(document));
        }
        this.updateVersion(document);
    }

    public static Element getDefaultDensity(Document document) {
        Element density = document.createElement("transmitterDensity");
        density.setAttribute("densityTx", "1.0");
        density.setAttribute("probabilityOfTransmission", "1.0");
        density.setAttribute("hourOfDay", "1.0");
        Element activity = document.createElement("activity");
        Element function = document.createElement("ConstantFunction");
        function.setAttribute("value", "1.0");
        activity.appendChild(function);
        density.appendChild(activity);
        return density;
    }

    @Override
    void migrateResultsDocument(Document document) {
    }

    private void updateVersion(Document document) {
        JXPathContext context = JXPathContext.newContext(document);
        context.createPathAndSetValue("Workspace/@workspace_format_version", this.getOriginalVersion().nextVersion().getNumber());
    }

    @Override
    public FormatVersion getOriginalVersion() {
        return new FormatVersion(51);
    }
}

