/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.migration.workspace;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.jxpath.JXPathContext;
import org.seamcat.migration.FormatVersion;
import org.seamcat.migration.workspace.AbstractScenarioMigration;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class Rule051UserDefinedDRSSWorkspaceMigration
extends AbstractScenarioMigration {
    private Map<String, Element> genericSystems = new HashMap<String, Element>();

    @Override
    public void migrateScenarioDocument(Document document) {
        JXPathContext context = JXPathContext.newContext(document);
        List list = context.selectNodes("//dRSS");
        Element drssElem = null;
        String victim = "NOT_GENERIC";
        if (list.size() > 0) {
            drssElem = (Element)list.get(0);
            victim = ((Element)drssElem.getParentNode()).getAttribute("victim");
        }
        List syss = context.selectNodes("//system/composite");
        for (Object e : syss) {
            Element s = (Element)e;
            if (!s.getAttribute("class").equals("org.seamcat.model.systems.generic.SystemModelGeneric")) continue;
            String id = ((Element)s.getParentNode()).getAttribute("id");
            this.genericSystems.put(id, s);
        }
        for (Map.Entry entry : this.genericSystems.entrySet()) {
            Element system = (Element)entry.getValue();
            Element path = (Element)system.getElementsByTagName("path").item(0).getFirstChild();
            Element methodElem = document.createElement("drss");
            path.appendChild(methodElem);
            if (((String)entry.getKey()).equals(victim)) {
                Element drss = document.createElement("drss");
                drss.setAttribute("enabled", drssElem.getAttribute("enabled"));
                Node child = drssElem.getFirstChild();
                drssElem.removeChild(child);
                drss.appendChild(child);
                methodElem.appendChild(drss);
                continue;
            }
            Rule051UserDefinedDRSSWorkspaceMigration.appendDefault(document, methodElem);
        }
        this.updateVersion(document);
    }

    public static void appendDefault(Document document, Element path) {
        Element drss = document.createElement("drss");
        drss.setAttribute("enabled", "false");
        Element distribution = document.createElement("distribution");
        distribution.setAttribute("constant", "0.0");
        distribution.setAttribute("max", "0.0");
        distribution.setAttribute("max-angle", "0.0");
        distribution.setAttribute("max-distance", "0.0");
        distribution.setAttribute("mean", "0.0");
        distribution.setAttribute("min", "0.0");
        distribution.setAttribute("std-dev", "0.0");
        distribution.setAttribute("step", "0.0");
        distribution.setAttribute("stepShift", "0.0");
        distribution.setAttribute("type", "0");
        drss.appendChild(distribution);
        path.appendChild(drss);
    }

    @Override
    void migrateResultsDocument(Document document) {
    }

    private void updateVersion(Document document) {
        JXPathContext context = JXPathContext.newContext(document);
        context.createPathAndSetValue("Workspace/@workspace_format_version", this.getOriginalVersion().nextVersion().getNumber());
    }

    @Override
    public FormatVersion getOriginalVersion() {
        return new FormatVersion(50);
    }
}

