/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.migration.workspace;

import java.util.List;
import org.apache.commons.jxpath.JXPathContext;
import org.seamcat.migration.FormatVersion;
import org.seamcat.migration.workspace.AbstractScenarioMigration;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Rule012CoverageRadiusWorkspaceMigration
extends AbstractScenarioMigration {
    @Override
    void migrateScenarioDocument(Document document) {
        this.updateVersion(document);
        JXPathContext context = JXPathContext.newContext(document);
        List trp = context.selectNodes("//TransmitterToReceiverPath");
        for (Object o : trp) {
            this.migrateCoverageRadius((Element)o, document);
        }
        List txs = context.selectNodes("//transmitter");
        for (Object tx : txs) {
            this.cleanupTransmitter((Element)tx);
        }
    }

    private void cleanupTransmitter(Element tx) {
        tx.removeAttribute("number_of_channels");
        tx.removeAttribute("number_of_users_per_channel");
    }

    @Override
    void migrateResultsDocument(Document document) {
    }

    private void updateVersion(Document document) {
        JXPathContext context = JXPathContext.newContext(document);
        context.createPathAndSetValue("Workspace/@workspace_format_version", this.getOriginalVersion().nextVersion().getNumber());
    }

    @Override
    public FormatVersion getOriginalVersion() {
        return new FormatVersion(11);
    }

    private void migrateCoverageRadius(Element cr, Document document) {
        Element parent = (Element)cr.getParentNode();
        double availability = this.attDouble(cr, "availability");
        double coverageRadius = this.attDouble(cr, "coverageRadius");
        int coverageRadiusCalculatinMode = this.attInt(cr, "coverageRadiusCalculatinMode");
        double density = this.attDouble(cr, "density");
        double fadingStdDev = this.attDouble(cr, "fadingStdDev");
        int frequencyCluster = this.attInt(cr, "frequencyCluster");
        double maximumDistance = this.attDouble(cr, "maximumDistance");
        double minimumDistance = this.attDouble(cr, "minimumDistance");
        int numberOfChannels = this.attInt(cr, "numberOfChannels");
        int numberOfUsersPerChannel = this.attInt(cr, "numberOfUsersPerChannel");
        double referenceReceiverAntennaHeight = this.attDouble(cr, "referenceReceiverAntennaHeight");
        double referenceTransmitterAntennaHeight = this.attDouble(cr, "referenceTransmitterAntennaHeight");
        double referenceTransmitterFrequency = this.attDouble(cr, "referenceTransmitterFrequency");
        double referenceTransmitterPower = this.attDouble(cr, "referenceTransmitterPower");
        Element pluginConfiguration = document.createElement("plugin-configuration");
        if (parent.getNodeName().equals("systemLink")) {
            if (coverageRadiusCalculatinMode == 1) {
                pluginConfiguration.setAttribute("classname", "org.seamcat.simulation.coverageradius.NoiseLimitedCoverageRadius");
                pluginConfiguration.setAttribute("param1", Double.toString(referenceReceiverAntennaHeight));
                pluginConfiguration.setAttribute("param2", Double.toString(referenceTransmitterAntennaHeight));
                pluginConfiguration.setAttribute("param3", Double.toString(referenceTransmitterFrequency));
                pluginConfiguration.setAttribute("param4", Double.toString(referenceTransmitterPower));
                pluginConfiguration.setAttribute("param5", Double.toString(minimumDistance));
                pluginConfiguration.setAttribute("param6", Double.toString(maximumDistance));
                pluginConfiguration.setAttribute("param7", Double.toString(availability));
                pluginConfiguration.setAttribute("param8", Double.toString(fadingStdDev));
            } else if (coverageRadiusCalculatinMode == 2) {
                pluginConfiguration.setAttribute("classname", "org.seamcat.simulation.coverageradius.TrafficLimitedNetworkCoverageRadius");
                pluginConfiguration.setAttribute("param1", Double.toString(density));
                pluginConfiguration.setAttribute("param2", Integer.toString(numberOfChannels));
                pluginConfiguration.setAttribute("param3", Integer.toString(numberOfUsersPerChannel));
                pluginConfiguration.setAttribute("param4", Integer.toString(frequencyCluster));
            } else {
                pluginConfiguration.setAttribute("classname", "org.seamcat.simulation.coverageradius.UserDefinedCoverageRadius");
                pluginConfiguration.setAttribute("param1", Double.toString(coverageRadius));
            }
            Element radius = document.createElement("CoverageRadius");
            radius.appendChild(pluginConfiguration);
            cr.appendChild(radius);
        }
    }

    private double attDouble(Element cr, String attribute) {
        String value = cr.getAttribute(attribute);
        cr.removeAttribute(attribute);
        try {
            return Double.parseDouble(value);
        }
        catch (NumberFormatException e) {
            return 0.0;
        }
    }

    private int attInt(Element cr, String attribute) {
        String value = cr.getAttribute(attribute);
        cr.removeAttribute(attribute);
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }
}

