/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.migration.settings;

import java.io.File;
import java.util.List;
import org.apache.commons.jxpath.JXPathContext;
import org.seamcat.migration.FileMigration;
import org.seamcat.migration.FormatVersion;
import org.seamcat.migration.MigrationIssue;
import org.seamcat.migration.XmlUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class Rule025SystemPluginSettingsMigration
implements FileMigration {
    @Override
    public void migrate(File originalFile, File migratedFile, List<MigrationIssue> migrationIssues) {
        Document document = XmlUtils.parse(originalFile);
        this.migrate(document);
        XmlUtils.write(document, migratedFile);
    }

    private void migrate(Document document) {
        JXPathContext context = JXPathContext.newContext(document);
        List systems = context.selectNodes("//system");
        for (Object system : systems) {
            Rule025SystemPluginSettingsMigration.fixSystem(document, (Element)system);
        }
        this.updateVersion(document);
    }

    public static void fixSystem(Document document, Element element) {
        element.setAttribute("location", "BUILT-IN");
        String aClass = element.getAttribute("class");
        element.removeAttribute("class");
        String pluginClass = null;
        switch (aClass) {
            case "org.seamcat.model.systems.generic.SystemModelGeneric": {
                pluginClass = "org.seamcat.simulation.generic.GenericSystemPlugin";
                break;
            }
            case "org.seamcat.model.systems.cdma.SystemModelCDMAUpLink": {
                pluginClass = "org.seamcat.simulation.hybrid.HybridCDMAUpLinkPlugin";
                break;
            }
            case "org.seamcat.model.systems.cdma.SystemModelCDMADownLink": {
                pluginClass = "org.seamcat.simulation.hybrid.HybridCDMADownLinkPlugin";
                break;
            }
            case "org.seamcat.model.systems.ofdma.SystemModelOFDMAUpLink": {
                pluginClass = "org.seamcat.simulation.hybrid.HybridOFDMAUpLinkPlugin";
                break;
            }
            case "org.seamcat.model.systems.ofdma.SystemModelOFDMADownLink": {
                pluginClass = "org.seamcat.simulation.hybrid.HybridOFDMADownLinkPlugin";
            }
        }
        element.setAttribute("classname", pluginClass);
        Element configuration = document.createElement("configuration");
        while (element.hasChildNodes()) {
            Node child = element.getFirstChild();
            element.removeChild(child);
            configuration.appendChild(child);
        }
        element.appendChild(configuration);
    }

    private void updateVersion(Document document) {
        JXPathContext context = JXPathContext.newContext(document);
        context.createPathAndSetValue("seamcat/@settings_format_version", this.getOriginalVersion().nextVersion().getNumber());
    }

    @Override
    public FormatVersion getOriginalVersion() {
        return new FormatVersion(24);
    }
}

