/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.migration.settings;

import java.io.File;
import java.util.List;
import org.apache.commons.jxpath.JXPathContext;
import org.seamcat.migration.FileMigration;
import org.seamcat.migration.FormatVersion;
import org.seamcat.migration.MigrationIssue;
import org.seamcat.migration.XmlUtils;
import org.seamcat.migration.settings.ChildHandler;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class Rule024CleanLibrarySettingsMigration
implements FileMigration {
    @Override
    public void migrate(File originalFile, File migratedFile, List<MigrationIssue> migrationIssues) {
        Document document = XmlUtils.parse(originalFile);
        this.migrate(document);
        XmlUtils.write(document, migratedFile);
    }

    private void migrate(Document document) {
        JXPathContext context = JXPathContext.newContext(document);
        this.renameAll(context, document, "spectrum-emission-masks/spectrum-emission-mask", "emissionMask");
        this.renameAll(context, document, "spectrum-emission-masks", "emissionMasks");
        this.renameAll(context, document, "receiver-blocking-masks", "blockingMasks");
        this.renameAll(context, document, "installed-jars", "jars");
        List jarDatas = context.selectNodes("//jarData");
        for (Object jarData : jarDatas) {
            Element data = (Element)jarData;
            CharacterData datasection = (CharacterData)data.getFirstChild();
            Element jar = (Element)data.getParentNode();
            jar.setAttribute("data", datasection.getData());
            jar.removeChild(data);
        }
        Rule024CleanLibrarySettingsMigration.handleCDMALLD(context.selectNodes("//CDMA-Link-level-data"), document);
        List list = context.selectNodes("//log-patterns");
        for (Object o : list) {
            Node lp = (Node)o;
            lp.getParentNode().removeChild(lp);
        }
        Node top = (Node)context.selectSingleNode("//seamcat");
        this.move(context, top, "systems");
        this.move(context, top, "receivers");
        this.move(context, top, "transmitters");
        this.move(context, top, "cdmalld");
        this.move(context, top, "emissionMasks");
        this.move(context, top, "blockingMasks");
        this.move(context, top, "pluginConfigurations");
        this.move(context, top, "jars");
        Node library = (Node)context.selectSingleNode("//library");
        library.getParentNode().removeChild(library);
        this.updateVersion(document);
    }

    private void move(JXPathContext context, Node to, String name) {
        Node ss = (Node)context.selectSingleNode("//" + name);
        ss.getParentNode().removeChild(ss);
        to.appendChild(ss);
    }

    private void renameAll(JXPathContext context, Document document, String name, String newName) {
        List llds = context.selectNodes("//" + name);
        for (Object lld : llds) {
            Element element = (Element)lld;
            document.renameNode(element, null, newName);
        }
    }

    private void updateVersion(Document document) {
        JXPathContext context = JXPathContext.newContext(document);
        context.createPathAndSetValue("seamcat/@settings_format_version", this.getOriginalVersion().nextVersion().getNumber());
    }

    public static void handleCDMALLD(List cdmas, final Document document) {
        for (Object cdma : cdmas) {
            Element element = (Element)cdma;
            element.setAttribute("systemType", element.getAttribute("system-type"));
            Element paths = document.createElement("paths");
            Rule024CleanLibrarySettingsMigration.moveChildren(element, paths, new ChildHandler(){

                @Override
                public void handle(Node child) {
                    Element path = (Element)child;
                    Element points = document.createElement("points");
                    Rule024CleanLibrarySettingsMigration.moveChildren(path, points, null);
                    path.appendChild(points);
                }
            });
            element.appendChild(paths);
            document.renameNode(element, null, "lld");
        }
    }

    private static void moveChildren(Element from, Element to, ChildHandler handler) {
        while (from.hasChildNodes()) {
            Node child = from.getFirstChild();
            if (handler != null) {
                handler.handle(child);
            }
            from.removeChild(child);
            to.appendChild(child);
        }
    }

    @Override
    public FormatVersion getOriginalVersion() {
        return new FormatVersion(23);
    }
}

