/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.migration.settings;

import java.io.File;
import java.util.List;
import org.apache.commons.jxpath.JXPathContext;
import org.seamcat.migration.FileMigration;
import org.seamcat.migration.FormatVersion;
import org.seamcat.migration.MigrationIssue;
import org.seamcat.migration.XmlUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class Rule014TransmitterCompositeSettingsMigration
implements FileMigration {
    @Override
    public void migrate(File originalFile, File migratedFile, List<MigrationIssue> migrationIssues) {
        Document document = XmlUtils.parse(originalFile);
        this.migrate(document);
        XmlUtils.write(document, migratedFile);
    }

    private void migrate(Document document) {
        JXPathContext context = JXPathContext.newContext(document);
        List transmitters = context.selectNodes("//transmitters/transmitter");
        for (Object o : transmitters) {
            Element transmitter = (Element)o;
            Rule014TransmitterCompositeSettingsMigration.migrateTransmitter(transmitter, document);
        }
        this.updateVersion(document);
    }

    public static void migrateTransmitter(Element transmitter, Document doc) {
        Element composite = doc.createElement("composite");
        composite.setAttribute("class", "org.seamcat.model.systems.generic.TransmitterModel");
        Element desc = doc.createElement("description");
        Element chars = doc.createElement("emissionCharacteristics");
        Rule014TransmitterCompositeSettingsMigration.moveAtt("cognitiveRadio", transmitter, chars);
        Rule014TransmitterCompositeSettingsMigration.moveAtt("dynamicRange", transmitter, chars);
        Rule014TransmitterCompositeSettingsMigration.moveAtt("minThreshold", transmitter, chars);
        Rule014TransmitterCompositeSettingsMigration.moveAtt("powerControl", transmitter, chars);
        Rule014TransmitterCompositeSettingsMigration.moveAtt("stepSize", transmitter, chars);
        Rule014TransmitterCompositeSettingsMigration.moveChild("power", transmitter, chars);
        Rule014TransmitterCompositeSettingsMigration.moveChild("emissionMask", transmitter, chars);
        Rule014TransmitterCompositeSettingsMigration.moveChild("emissionFloor", transmitter, chars);
        Element transceiver = (Element)transmitter.getElementsByTagName("transceiver").item(0);
        Element pointing = doc.createElement("antennaPointing");
        Rule014TransmitterCompositeSettingsMigration.moveAtt("antennaPointingAzimuth", transceiver, pointing);
        Rule014TransmitterCompositeSettingsMigration.moveAtt("antennaPointingElevation", transceiver, pointing);
        Rule014TransmitterCompositeSettingsMigration.moveChild("antennaHeight", transceiver, pointing);
        Rule014TransmitterCompositeSettingsMigration.moveChild("azimuth", transceiver, pointing);
        Rule014TransmitterCompositeSettingsMigration.moveChild("elevation", transceiver, pointing);
        String reference = transceiver.getAttribute("reference");
        transceiver.removeAttribute("reference");
        desc.setAttribute("name", reference);
        composite.appendChild(desc);
        Rule014TransmitterCompositeSettingsMigration.moveChild("antennaGain", transceiver, composite);
        composite.appendChild(pointing);
        composite.appendChild(chars);
        Node node = transmitter.getParentNode();
        node.removeChild(transmitter);
        node.appendChild(composite);
    }

    private static void moveAtt(String name, Element from, Element to) {
        String attValue = from.getAttribute(name);
        from.removeAttribute(name);
        to.setAttribute(name, attValue);
    }

    private static void moveChild(String name, Element from, Element to) {
        Node child = from.getElementsByTagName(name).item(0);
        from.removeChild(child);
        to.appendChild(child);
    }

    private void updateVersion(Document document) {
        JXPathContext context = JXPathContext.newContext(document);
        context.createPathAndSetValue("seamcat/@settings_format_version", this.getOriginalVersion().nextVersion().getNumber());
    }

    @Override
    public FormatVersion getOriginalVersion() {
        return new FormatVersion(13);
    }
}

