/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.migration.settings;

import java.io.File;
import java.util.List;
import org.apache.commons.jxpath.JXPathContext;
import org.seamcat.migration.FileMigration;
import org.seamcat.migration.FormatVersion;
import org.seamcat.migration.MigrationIssue;
import org.seamcat.migration.XmlUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class Rule013ReceiverSettingsMigration
implements FileMigration {
    @Override
    public void migrate(File originalFile, File migratedFile, List<MigrationIssue> migrationIssues) {
        Document document = XmlUtils.parse(originalFile);
        this.migrate(document);
        XmlUtils.write(document, migratedFile);
    }

    private void migrate(Document document) {
        JXPathContext context = JXPathContext.newContext(document);
        List receivers = context.selectNodes("//receivers/receiver");
        for (Object o : receivers) {
            Element receiver = (Element)o;
            Rule013ReceiverSettingsMigration.migrateReceiver(receiver, document);
        }
        this.updateVersion(document);
    }

    public static void migrateReceiver(Element receiver, Document doc) {
        Element composite = doc.createElement("composite");
        composite.setAttribute("class", "org.seamcat.model.systems.generic.ReceiverModel");
        Element desc = doc.createElement("description");
        Element crit = doc.createElement("interferenceCriteria");
        Rule013ReceiverSettingsMigration.moveAtt("extended_protection_ratio", receiver, crit);
        Rule013ReceiverSettingsMigration.moveAtt("interference_to_noise_ratio", receiver, crit);
        Rule013ReceiverSettingsMigration.moveAtt("noise_augmentation", receiver, crit);
        Rule013ReceiverSettingsMigration.moveAtt("protection_ratio", receiver, crit);
        Element recep = doc.createElement("receptionCharacteristics");
        Rule013ReceiverSettingsMigration.moveAtt("blockingAttenuationMode", receiver, recep);
        Rule013ReceiverSettingsMigration.moveAtt("receivePower", receiver, recep);
        Rule013ReceiverSettingsMigration.moveAtt("reception_bandwith", receiver, recep);
        Rule013ReceiverSettingsMigration.moveAtt("sensitivity", receiver, recep);
        Rule013ReceiverSettingsMigration.moveAtt("use_receivePower", receiver, recep);
        Rule013ReceiverSettingsMigration.moveAtt("use_receiver_overloading", receiver, recep);
        Rule013ReceiverSettingsMigration.moveChild("noiseFloor", receiver, recep);
        Rule013ReceiverSettingsMigration.moveChild("blockingMask", receiver, recep);
        Rule013ReceiverSettingsMigration.moveChild("intermodulation_rejection", receiver, recep);
        Rule013ReceiverSettingsMigration.moveChild("overloading_mask", receiver, recep);
        Rule013ReceiverSettingsMigration.moveChild("receiver_filter", receiver, recep);
        Element transceiver = (Element)receiver.getElementsByTagName("transceiver").item(0);
        Element pointing = doc.createElement("antennaPointing");
        Rule013ReceiverSettingsMigration.moveAtt("antennaPointingAzimuth", transceiver, pointing);
        Rule013ReceiverSettingsMigration.moveAtt("antennaPointingElevation", transceiver, pointing);
        Rule013ReceiverSettingsMigration.moveChild("antennaHeight", transceiver, pointing);
        Rule013ReceiverSettingsMigration.moveChild("azimuth", transceiver, pointing);
        Rule013ReceiverSettingsMigration.moveChild("elevation", transceiver, pointing);
        String reference = transceiver.getAttribute("reference");
        transceiver.removeAttribute("reference");
        desc.setAttribute("name", reference);
        composite.appendChild(desc);
        Rule013ReceiverSettingsMigration.moveChild("antennaGain", transceiver, composite);
        composite.appendChild(pointing);
        composite.appendChild(crit);
        composite.appendChild(recep);
        Node node = receiver.getParentNode();
        node.removeChild(receiver);
        node.appendChild(composite);
    }

    private static void moveAtt(String name, Element from, Element to) {
        String attValue = from.getAttribute(name);
        from.removeAttribute(name);
        to.setAttribute(name, attValue);
    }

    private static void moveChild(String name, Element from, Element to) {
        Node child = from.getElementsByTagName(name).item(0);
        from.removeChild(child);
        to.appendChild(child);
    }

    private void updateVersion(Document document) {
        JXPathContext context = JXPathContext.newContext(document);
        context.createPathAndSetValue("seamcat/@settings_format_version", this.getOriginalVersion().nextVersion().getNumber());
    }

    @Override
    public FormatVersion getOriginalVersion() {
        return new FormatVersion(12);
    }
}

