/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.migration.settings;

import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.jxpath.JXPathContext;
import org.seamcat.migration.FileMigration;
import org.seamcat.migration.FormatVersion;
import org.seamcat.migration.MigrationIssue;
import org.seamcat.migration.XmlUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Rule010PropagationRenameSettingsMigration
implements FileMigration {
    private static Map<String, String> names = new HashMap<String, String>();

    @Override
    public void migrate(File originalFile, File migratedFile, List<MigrationIssue> migrationIssues) {
        Document document = XmlUtils.parse(originalFile);
        this.migrate(document);
        XmlUtils.write(document, migratedFile);
    }

    private void migrate(Document document) {
        JXPathContext context = JXPathContext.newContext(document);
        List pms = context.selectNodes("//pluginConfiguration");
        for (Object o : pms) {
            Rule010PropagationRenameSettingsMigration.patchBuildIn((Element)o);
        }
        this.updateVersion(document);
    }

    public static void patchBuildIn(Element element) {
        String name;
        String classname = element.getAttribute("classname");
        if ("org.seamcat.model.propagation.R370PropagationModel".equals(classname)) {
            element.removeAttribute("classname");
            element.setAttribute("classname", "org.seamcat.model.propagation.P1546ver1PropagationModel");
        }
        if ("org.seamcat.model.propagation.P1546ver3PropagationModel".equals(classname)) {
            element.removeAttribute("classname");
            element.setAttribute("classname", "org.seamcat.model.propagation.P1546ver4PropagationModel");
        }
        if ((name = names.get(element.getAttribute("classname"))) != null) {
            element.setAttribute("name", name);
        }
    }

    private void updateVersion(Document document) {
        JXPathContext context = JXPathContext.newContext(document);
        context.createPathAndSetValue("seamcat/@settings_format_version", this.getOriginalVersion().nextVersion().getNumber());
    }

    @Override
    public FormatVersion getOriginalVersion() {
        return new FormatVersion(9);
    }

    static {
        names.put("org.seamcat.model.propagation.HataSE21PropagationModel", "Extended Hata");
        names.put("org.seamcat.model.propagation.HataSE24PropagationModel", "Extended Hata - SRD");
        names.put("org.seamcat.model.propagation.FreeSpacePropagationModel", "Free Space (ITU-R P.525)");
        names.put("org.seamcat.model.propagation.LongleyRice_mod", "Longley Rice");
        names.put("org.seamcat.model.propagation.Model_C_IEEE_802_11_rev3", "Model C IEEE 802.11 rev3");
        names.put("org.seamcat.model.propagation.P452ver14PropagationModel", "ITU-R P.452-14");
        names.put("org.seamcat.model.propagation.P1411LowAntennaHeight", "ITU-R P.1411 Low Antenna Height");
        names.put("org.seamcat.model.propagation.P1546ver1PropagationModel", "ITU-R P.1546-1 Annex 8");
        names.put("org.seamcat.model.propagation.P1546ver4PropagationModel", "ITU-R P.1546-4 land");
        names.put("org.seamcat.model.propagation.SDPropagationModel", "Spherical Diffraction (ITU-R P.526-2)");
    }
}

