/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.migration.batch;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.seamcat.migration.FileMigration;
import org.seamcat.migration.FormatVersion;
import org.seamcat.migration.IOUtils;
import org.seamcat.migration.MigrationException;
import org.seamcat.migration.MigrationIssue;
import org.seamcat.migration.XmlUtils;
import org.seamcat.migration.batch.BatchFormatVersionConstants;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class XmlToZipFileMigration
implements FileMigration {
    @Override
    public void migrate(File originalFile, File migratedFile, List<MigrationIssue> migrationIssues) {
        try {
            this.tryMigrate(originalFile, migratedFile);
        }
        catch (Exception e) {
            throw new MigrationException("Failed to migrate XML batch to ZIP batch", e);
        }
    }

    public void tryMigrate(File originalFile, File migratedFile) throws Exception {
        Document parse = XmlUtils.parse(originalFile);
        Element element = parse.getDocumentElement();
        if (element.getTagName().equals("BatchJobList")) {
            this.createZipFileFromScenarioAndResultsFiles(migratedFile, parse);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createZipFileFromScenarioAndResultsFiles(File migratedFile, Document original) throws Exception {
        ZipOutputStream zipOutputStream = null;
        try {
            zipOutputStream = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(migratedFile)));
            ZipEntry scenarioEntry = new ZipEntry("batch.xml");
            zipOutputStream.putNextEntry(scenarioEntry);
            XmlUtils.write(original, zipOutputStream);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(zipOutputStream);
            throw throwable;
        }
        IOUtils.closeQuietly(zipOutputStream);
    }

    @Override
    public FormatVersion getOriginalVersion() {
        return BatchFormatVersionConstants.PREHISTORIC;
    }
}

