/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.migration.batch;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.seamcat.migration.FileMigration;
import org.seamcat.migration.MigrationException;
import org.seamcat.migration.MigrationIssue;
import org.seamcat.migration.XmlUtils;
import org.w3c.dom.Document;

public abstract class AbstractScenarioMigration
implements FileMigration {
    @Override
    public void migrate(File originalZipFile, File migratedZipFile, List<MigrationIssue> migrationIssues) {
        try {
            ZipFile zipFile = new ZipFile(originalZipFile);
            ZipOutputStream resultStream = new ZipOutputStream(new FileOutputStream(migratedZipFile));
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                Document document;
                ZipEntry entry = entries.nextElement();
                resultStream.putNextEntry(new ZipEntry(entry.getName()));
                if (entry.getName().equals("batch.xml")) {
                    document = XmlUtils.parse(zipFile.getInputStream(entry));
                    this.migrateScenarioDocument(document);
                    XmlUtils.write(document, resultStream);
                    continue;
                }
                document = XmlUtils.parse(zipFile.getInputStream(entry));
                this.migrateResultsDocument(document);
                XmlUtils.write(document, resultStream);
            }
            resultStream.close();
            zipFile.close();
        }
        catch (IOException e) {
            throw new MigrationException(e);
        }
    }

    abstract void migrateScenarioDocument(Document var1);

    abstract void migrateResultsDocument(Document var1);
}

