/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.migration;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.Arrays;
import org.seamcat.migration.FormatVersion;
import org.seamcat.migration.IOUtils;
import org.seamcat.migration.MigrationException;

public abstract class VersionExtractor {
    private static final String XML_PROLOG_SIGNATURE_STRING = "<?xml";
    private static final byte[] ZIP_HEADER_SIGNATURE_BYTES = new byte[]{80, 75, 3, 4};

    public abstract FormatVersion extractVersion(File var1);

    protected FileType determineFileType(File file) {
        if (this.readFirstChars(file, XML_PROLOG_SIGNATURE_STRING.length()).equals(XML_PROLOG_SIGNATURE_STRING)) {
            return FileType.XML_FILE;
        }
        if (Arrays.equals(this.readFirstBytes(file, ZIP_HEADER_SIGNATURE_BYTES.length), ZIP_HEADER_SIGNATURE_BYTES)) {
            return FileType.ZIP_FILE;
        }
        throw new MigrationException("File type not recognized for " + file);
    }

    private byte[] readFirstBytes(File file, int i) {
        byte[] buffer = new byte[i];
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(file);
            inputStream.read(buffer);
        }
        catch (Exception e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(inputStream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly(inputStream);
        return buffer;
    }

    private Object readFirstChars(File file, int i) {
        char[] buffer = new char[i];
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(file);
            new InputStreamReader((InputStream)inputStream, Charset.forName("latin1")).read(buffer);
        }
        catch (Exception e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(inputStream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly(inputStream);
        return new String(buffer);
    }

    protected static enum FileType {
        XML_FILE,
        ZIP_FILE;

    }
}

