/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.migration;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.Logger;
import org.seamcat.migration.BackwardMigrationNotSupportedException;
import org.seamcat.migration.FileMigration;
import org.seamcat.migration.FormatVersion;
import org.seamcat.migration.IOUtils;
import org.seamcat.migration.MigrationException;
import org.seamcat.migration.MigrationIssue;
import org.seamcat.migration.MigrationRegistry;
import org.seamcat.migration.VersionExtractor;

public class FileMigrator {
    private static final Logger logger = Logger.getLogger(FileMigrator.class);
    private FormatVersion currentVersion;
    private VersionExtractor versionExtractor;
    private MigrationRegistry migrationRegistry;

    public File migrate(File file, List<MigrationIssue> migrationIssues) {
        return this.migrateToVersion(file, migrationIssues, this.currentVersion);
    }

    public File migrateToVersion(File originalFile, List<MigrationIssue> migrationIssues, FormatVersion targetVersion) {
        FormatVersion originalFileVersion = this.versionExtractor.extractVersion(originalFile);
        logger.info("File " + originalFile + " is at version " + originalFileVersion.getNumber());
        List<FileMigration> migrations = this.findMigrations(originalFileVersion, targetVersion);
        logger.debug("Found " + migrations.size() + " migrations from version " + originalFileVersion + " to " + targetVersion);
        if (migrations.size() > 0) {
            return this.runMigrations(originalFile, migrations, migrationIssues);
        }
        return originalFile;
    }

    private List<FileMigration> findMigrations(FormatVersion originalVersion, FormatVersion targetVersion) {
        if (originalVersion.equals(targetVersion)) {
            return Collections.emptyList();
        }
        if (originalVersion.isLaterThan(targetVersion)) {
            throw new BackwardMigrationNotSupportedException("Can't migrate backwards");
        }
        List<FormatVersion> versionRange = FormatVersion.rangeOf(originalVersion, targetVersion);
        return this.findMigrationsForVersionRange(versionRange);
    }

    private List<FileMigration> findMigrationsForVersionRange(List<FormatVersion> versionRange) {
        ArrayList<FileMigration> migrations = new ArrayList<FileMigration>();
        for (int i = 0; i < versionRange.size() - 1; ++i) {
            FileMigration migration = this.migrationRegistry.findMigration(versionRange.get(i));
            if (migration == null) {
                throw new MigrationException("No migration found between versions " + versionRange.get(i) + " and " + versionRange.get(i + 1));
            }
            migrations.add(migration);
        }
        return migrations;
    }

    private File runMigrations(File originalFile, List<FileMigration> migrations, List<MigrationIssue> migrationIssues) {
        File currentFile = originalFile;
        for (FileMigration migration : migrations) {
            File nextFile = IOUtils.createTempFile();
            logger.info("Running migration " + migration.getClass().getName());
            logger.debug("(current: " + currentFile + ", next: " + nextFile + ")");
            migration.migrate(currentFile, nextFile, migrationIssues);
            if (currentFile != originalFile) {
                currentFile.delete();
            }
            currentFile = nextFile;
        }
        return currentFile;
    }

    public void setCurrentVersion(FormatVersion currentVersion) {
        this.currentVersion = currentVersion;
    }

    public void setVersionExtractor(VersionExtractor versionExtractor) {
        this.versionExtractor = versionExtractor;
    }

    public void setMigrationRegistry(MigrationRegistry migrationRegistry) {
        this.migrationRegistry = migrationRegistry;
    }
}

