/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.marshalling;

import org.seamcat.batch.BatchJobList;
import org.seamcat.marshalling.WorkspaceMarshaller;
import org.seamcat.migration.batch.BatchFormatVersionConstants;
import org.seamcat.model.Workspace;
import org.seamcat.persistence.Marshaller;
import org.seamcat.persistence.Processor;
import org.seamcat.persistence.UnMarshaller;

public class BatchMarshaller {
    public static BatchJobList unMarshall(final UnMarshaller un, String name) {
        un.checkBeginElement("BatchJobList");
        final BatchJobList batch = new BatchJobList(name, un.attribute("batch_description"));
        String incrementalSave = un.attribute("incrementalSave");
        if (incrementalSave != null && !incrementalSave.isEmpty()) {
            boolean incSave = false;
            try {
                incSave = Boolean.parseBoolean(incrementalSave);
            }
            catch (Exception exception) {
                // empty catch block
            }
            batch.setIncrementalSave(incSave);
        }
        un.processWrappedElementSequence("workspaces", "Workspace", new Processor(){

            @Override
            public void process() {
                batch.addBatchJob(WorkspaceMarshaller.unmarshall(un));
            }
        });
        un.checkEndElement("BatchJobList");
        return batch;
    }

    public static void marshall(Marshaller marshaller, BatchJobList batch) {
        marshaller.beginElement("BatchJobList");
        marshaller.attribute("batch_description", batch.getDescription());
        marshaller.attribute("incrementalSave", Boolean.toString(batch.getIncrementalSave()));
        marshaller.attribute("batch_format_version", Integer.toString(BatchFormatVersionConstants.CURRENT_VERSION.getNumber()));
        marshaller.beginElement("workspaces");
        for (Workspace bj : batch.getBatchJobs()) {
            WorkspaceMarshaller.toElement(bj, marshaller);
        }
        marshaller.endElement("workspaces");
        marshaller.endElement("BatchJobList");
    }
}

