/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.loadsave;

import java.util.ArrayList;
import java.util.List;
import org.seamcat.marshalling.WorkspaceResultMarshaller;
import org.seamcat.model.Workspace;
import org.seamcat.model.engines.LinkResultSamplesImpl;
import org.seamcat.model.simulation.result.LinkResult;
import org.seamcat.model.types.result.Results;
import org.seamcat.persistence.Processor;
import org.seamcat.persistence.UnMarshaller;
import org.seamcat.persistence.impl.LinkResultMarshaller;
import org.seamcat.scenario.WorkspaceScenario;
import org.seamcat.simulation.result.SimulationResultImpl;

public class ResultLoader {
    public static void readResultsFromXmlStream(Workspace workspace, final UnMarshaller unMarshaller) {
        int i;
        unMarshaller.checkBeginElement("workspaceResults");
        WorkspaceScenario scenario = new WorkspaceScenario(workspace);
        List<Results> seamcatResults = WorkspaceResultMarshaller.loadFromXmlStream(scenario, unMarshaller, "SEAMCATResults", "SEAMCATResult");
        List<Results> eppResults = WorkspaceResultMarshaller.loadFromXmlStream(scenario, unMarshaller, "EventProcessingResults", "EventProcessingResult");
        final SimulationResultImpl result = new SimulationResultImpl();
        result.setVictimResult(seamcatResults.get(0));
        for (i = 1; i < seamcatResults.size() - 1; ++i) {
            result.setResult(scenario.getInterferenceLinks().get(i - 1), seamcatResults.get(i));
        }
        result.setStatistics(seamcatResults.get(seamcatResults.size() - 1));
        for (i = 0; i < eppResults.size(); ++i) {
            result.setResult(scenario.getEventProcessingList().get(i), eppResults.get(i));
        }
        workspace.setSimulationResult(result);
        workspace.setScenario(scenario);
        unMarshaller.processOptionalElement("samples", new Processor(){

            @Override
            public void process() {
                final ArrayList<LinkResult> victim = new ArrayList<LinkResult>();
                final ArrayList<LinkResult> interferer = new ArrayList<LinkResult>();
                unMarshaller.processWrappedElementSequence("victim", "linkResult", new Processor(){

                    @Override
                    public void process() {
                        victim.add(LinkResultMarshaller.unMarshall(unMarshaller));
                    }
                });
                unMarshaller.processWrappedElementSequence("interferer", "linkResult", new Processor(){

                    @Override
                    public void process() {
                        interferer.add(LinkResultMarshaller.unMarshall(unMarshaller));
                    }
                });
                result.setLinkResultSamples(new LinkResultSamplesImpl(victim, interferer));
            }
        });
        unMarshaller.checkEndElement("workspaceResults");
    }
}

