/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.loadsave;

import java.io.File;
import java.io.IOException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.seamcat.batch.BatchJobList;
import org.seamcat.commands.CancelLoadCommand;
import org.seamcat.eventbus.EventBusFactory;
import org.seamcat.eventbus.EventHandler;
import org.seamcat.loadsave.LoadException;
import org.seamcat.loadsave.ResultLoader;
import org.seamcat.marshalling.BatchMarshaller;
import org.seamcat.migration.IOUtils;
import org.seamcat.model.Workspace;
import org.seamcat.persistence.UnMarshaller;
import org.seamcat.presentation.Utils;

public class BatchLoader {
    private boolean loadCancelled = false;
    private UnMarshaller unMarshaller;

    public BatchLoader() {
        EventBusFactory.getEventBus().subscribe(this);
    }

    public BatchJobList loadFromFile(File file) throws IOException {
        ZipFile zipFile = new ZipFile(file);
        BatchJobList batch = this.loadBatchScenarioFromZipFile(zipFile, Utils.filenameWithoutExtension(file));
        batch.setAbsoluteLocation(file.getAbsolutePath());
        this.loadResultsIntoBatch(batch, zipFile);
        return batch;
    }

    private BatchJobList loadBatchScenarioFromZipFile(ZipFile zipFile, String name) {
        ZipEntry scenarioEntry = zipFile.getEntry("batch.xml");
        if (scenarioEntry == null) {
            throw new LoadException("Failed to load workspace. Scenario entry not found in zip file.");
        }
        try {
            UnMarshaller un = IOUtils.fromInputStream(zipFile.getInputStream(scenarioEntry));
            return BatchMarshaller.unMarshall(un, name);
        }
        catch (Exception e) {
            throw new LoadException("Failed to load batch", e);
        }
    }

    private void loadResultsIntoBatch(BatchJobList batch, ZipFile zipFile) {
        for (Workspace item : batch.getBatchJobs()) {
            if (!item.isHasBeenCalculated()) continue;
            ZipEntry resultsEntry = zipFile.getEntry(item.getName() + "_results.xml");
            if (resultsEntry != null) {
                try {
                    this.unMarshaller = IOUtils.fromInputStream(zipFile.getInputStream(resultsEntry));
                    ResultLoader.readResultsFromXmlStream(item, this.unMarshaller);
                    continue;
                }
                catch (Exception e) {
                    throw new LoadException("Failed to load results into workspace.", e);
                }
            }
            item.setHasBeenCalculated(false);
        }
    }

    public boolean isCancelled() {
        return this.loadCancelled;
    }

    @EventHandler
    public void cancel(CancelLoadCommand command) {
        this.loadCancelled = true;
        this.unMarshaller.cancel();
    }

    protected void finalize() throws Throwable {
        super.finalize();
        EventBusFactory.getEventBus().unsubscribe(this);
    }
}

