/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.function;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.seamcat.function.BinarySearch;
import org.seamcat.function.DiscreteFunction;
import org.seamcat.model.functions.FunctionException;
import org.seamcat.model.functions.MaskFunction;
import org.seamcat.model.geometry.Point2D;
import org.seamcat.model.mathematics.Mathematics;

public class MaskFunctionImpl
extends DiscreteFunction
implements MaskFunction {
    private Map<Point2D, Double> mask = new HashMap<Point2D, Double>();

    public MaskFunctionImpl() {
        this(new ArrayList<Point2D>(), new ArrayList<Double>());
    }

    public MaskFunctionImpl(List<Point2D> points, List<Double> mask) {
        super(points);
        for (int i = 0; i < points.size(); ++i) {
            Point2D point = points.get(i);
            this.mask.put(point, mask.get(i));
        }
    }

    @Override
    public boolean isConstant() {
        return false;
    }

    public void updatePoint(Point2D oldPoint, Point2D newPoint) {
        Double maskValue = this.mask.get(oldPoint);
        this.mask.remove(oldPoint);
        this.points().remove(oldPoint);
        this.addPoint(newPoint, maskValue);
    }

    public void addPoint(Point2D point, double mask) {
        this.addPoint(point);
        this.mask.put(point, mask);
    }

    @Override
    public double integrate(double bandwithDifference, double referenceBandwith) throws FunctionException {
        if (this.isConstant()) {
            return 0.0;
        }
        bandwithDifference = (double)((long)(bandwithDifference * 1000000.0)) / 1000000.0;
        try {
            this.checkIntegration(bandwithDifference, referenceBandwith);
            return this.calculateIntegration(bandwithDifference, referenceBandwith);
        }
        catch (FunctionException e) {
            return 0.0;
        }
    }

    private double calculateIntegration(double bandwithDifference, double referenceBandwith) {
        int i = 0;
        int j = 0;
        int size = this.points().size();
        double rXa = 0.0;
        double rXb = 0.0;
        double rYaLin = 0.0;
        double rYbLin = 0.0;
        double rYa = 0.0;
        double rYb = 0.0;
        double rSum = 0.0;
        if (size < 2) {
            return 0.0;
        }
        final Double value = bandwithDifference - referenceBandwith * 0.5;
        i = BinarySearch.search(this.points(), new BinarySearch.Filter<Point2D>(){

            @Override
            public boolean evaluate(Point2D point, int index) {
                return point.getX() <= value;
            }
        });
        rXa = bandwithDifference - referenceBandwith * 0.5;
        rYa = this.points().get(Math.max(i - 1, 0)).getY() + (this.points().get(i).getY() - this.points().get(Math.max(i - 1, 0)).getY()) / (this.points().get(i).getX() - this.points().get(Math.max(i - 1, 0)).getX()) * (rXa - this.points().get(Math.max(i - 1, 0)).getX());
        rYaLin = Math.pow(10.0, rYa / 10.0);
        boolean wasInsideForLoop = false;
        for (j = i; j < size && bandwithDifference + referenceBandwith * 0.5 >= this.points().get(j).getX(); ++j) {
            rXb = this.points().get(j).getX();
            rYb = this.points().get(j).getY();
            rYbLin = Math.pow(10.0, rYb / 10.0);
            rSum = rYb == rYa ? (rSum += (rXb - rXa) * rYaLin) : (rSum += 10.0 / Math.log(10.0) * (rXb - rXa) / (rYb - rYa) * (rYbLin - rYaLin));
            rYa = rYb;
            rXa = rXb;
            rYaLin = rYbLin;
            wasInsideForLoop = true;
        }
        if (j == size) {
            --j;
        }
        if (bandwithDifference + referenceBandwith * 0.5 < this.points().get(j).getX() || !wasInsideForLoop) {
            rXb = bandwithDifference + referenceBandwith * 0.5;
            rYb = this.points().get(j - 1).getY() + (this.points().get(j).getY() - this.points().get(j - 1).getY()) / (this.points().get(j).getX() - this.points().get(j - 1).getX()) * (rXb - this.points().get(j - 1).getX());
            rYbLin = Math.pow(10.0, rYb / 10.0);
            rSum = rYb == rYa ? (rSum += (rXb - rXa) * rYaLin) : (rSum += 10.0 / Math.log(10.0) * (rXb - rXa) / (rYb - rYa) * (rYbLin - rYaLin));
        }
        if (rSum != 0.0) {
            return Mathematics.linear2dB(rSum);
        }
        return rSum;
    }

    private void checkIntegration(double bandwithDifference, double referenceBandwidth) throws FunctionException {
        int size = this.points().size();
        double v = bandwithDifference - referenceBandwidth * 0.5;
        double y = bandwithDifference + referenceBandwidth * 0.5;
        if (size == 0 || v < this.points().get(0).getX() || y > this.points().get(size - 1).getX()) {
            throw new FunctionException("Emission mask is undefined at the begining or at the end of the reception bandwidth");
        }
    }

    @Override
    public MaskFunction normalize() {
        MaskFunctionImpl normalized = new MaskFunctionImpl();
        for (Point2D point : this.points()) {
            double rZ = this.mask.get(point);
            double rY = point.getY();
            normalized.addPoint(new Point2D(point.getX(), rY -= Mathematics.linear2dB(rZ / 1000.0)), 1000.0);
        }
        return normalized;
    }

    @Override
    public Double getMask(Point2D point) {
        return this.mask.get(point);
    }

    public void setMask(Point2D point, double maskValue) {
        this.mask.put(point, maskValue);
    }

    @Override
    public String toString() {
        return "Mask Function";
    }
}

