/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.function;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.seamcat.function.BinarySearch;
import org.seamcat.function.WithPoints;
import org.seamcat.model.functions.Bounds;
import org.seamcat.model.functions.Function;
import org.seamcat.model.functions.FunctionException;
import org.seamcat.model.geometry.Point2D;
import org.seamcat.model.mathematics.Mathematics;

public class DiscreteFunction
implements Function,
WithPoints {
    private List<Point2D> points = new ArrayList<Point2D>();
    private boolean isConstant;
    private double constant;

    public DiscreteFunction() {
        this.setPoints(new ArrayList<Point2D>());
    }

    public DiscreteFunction(List<Point2D> _points) {
        this.setPoints(_points);
    }

    public DiscreteFunction(double constant) {
        this.setConstant(constant);
    }

    public void setPoints(List<Point2D> points) {
        this.isConstant = false;
        this.points = points;
    }

    public void setConstant(double constant) {
        this.isConstant = true;
        this.constant = constant;
    }

    @Override
    public List<Point2D> points() {
        return this.points;
    }

    public final void addPoint(Point2D point) {
        this.points.add(point);
        this.sortPoints();
    }

    @Override
    public double evaluate(double rX) throws FunctionException {
        if (this.isConstant) {
            return this.constant;
        }
        int size = this.points.size();
        if (size == 0) {
            return 0.0;
        }
        double rLast = this.points.get(size - 1).getX();
        double rFirst = this.points.get(0).getX();
        if (rX > rLast || rX < rFirst) {
            throw new FunctionException("Specified value (" + rX + ") is outside bounds [" + rFirst + " to " + rLast + "]");
        }
        final Double _rX = rX;
        int i = BinarySearch.search(this.points, new BinarySearch.Filter<Point2D>(){

            @Override
            public boolean evaluate(Point2D point, int index) {
                return _rX > point.getX();
            }
        });
        if (i == 0) {
            return this.points.get(0).getY();
        }
        if (rX == this.points.get(i).getX()) {
            return this.points.get(i).getY();
        }
        return Mathematics.linearInterpolate(rX, this.points.get(i - 1), this.points.get(i));
    }

    @Override
    public double evaluateMax() {
        if (this.isConstant) {
            return this.constant;
        }
        double rFinalY = this.points.get(0).getY();
        for (Point2D p : this.points) {
            double rY = p.getY();
            if (!(rY > rFinalY)) continue;
            rFinalY = rY;
        }
        return rFinalY;
    }

    @Override
    public double evaluateMin() {
        if (this.isConstant) {
            return this.constant;
        }
        double rFinalY = this.points.get(0).getY();
        for (Point2D p : this.points) {
            double rY = p.getY();
            if (!(rY < rFinalY)) continue;
            rFinalY = rY;
        }
        return rFinalY;
    }

    @Override
    public boolean isConstant() {
        return this.isConstant;
    }

    public void sortPoints() {
        Collections.sort(this.points(), Point2D.X_COMPARATOR);
    }

    public String toString() {
        return DiscreteFunction.pretty(this);
    }

    public static String pretty(Function function) {
        if (function.isConstant()) {
            return "Constant (" + function.getConstant() + ")";
        }
        return "User defined function";
    }

    @Override
    public Bounds getBounds() {
        if (this.isConstant) {
            return new Bounds(Double.MIN_VALUE, Double.MAX_VALUE, false);
        }
        if (this.points.size() == 0) {
            return new Bounds(0.0, 0.0, true);
        }
        return new Bounds(this.points.get(0).getX(), this.points.get(this.points.size() - 1).getX(), true);
    }

    @Override
    public DiscreteFunction offset(double offset) {
        if (this.isConstant) {
            return new DiscreteFunction(this.constant + offset);
        }
        ArrayList<Point2D> offsetPoints = new ArrayList<Point2D>();
        for (Point2D d : this.points) {
            offsetPoints.add(new Point2D(d.getX(), d.getY() + offset));
        }
        return new DiscreteFunction(offsetPoints);
    }

    @Override
    public double getConstant() {
        if (this.isConstant) {
            return this.constant;
        }
        throw new UnsupportedOperationException("Non constant function");
    }

    @Override
    public List<Point2D> getPoints() {
        if (this.isConstant) {
            throw new UnsupportedOperationException("No points on a constant function");
        }
        return Collections.unmodifiableList(this.points);
    }
}

