/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.exception;

import java.awt.EventQueue;
import org.apache.log4j.Logger;
import org.seamcat.presentation.DialogHelper;

public class SeamcatUncaughtExceptionHandler
implements Thread.UncaughtExceptionHandler {
    private static final Logger logger = Logger.getLogger(SeamcatUncaughtExceptionHandler.class);

    @Override
    public void uncaughtException(Thread thread, Throwable exception) {
        try {
            logger.error("Uncaught exception in thread " + thread.getName(), exception);
        }
        catch (Throwable t) {
            System.err.println("**** Exception while handling uncaught exception in thread ****");
        }
    }

    private void showErrorDialogLater(final Throwable exception) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    DialogHelper.generalSeamcatError(exception);
                }
                catch (Throwable t) {
                    System.err.println("**** Exception while trying to show error dialog, while handling uncaught exception in thread ****");
                }
            }
        });
    }
}

