/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.eventprocessing.ituantennas;

import org.seamcat.model.distributions.Distribution;
import org.seamcat.model.factory.Factory;
import org.seamcat.model.plugin.Config;
import org.seamcat.model.plugin.OptionalValue;
import org.seamcat.model.plugin.antenna.TiltModes;

public interface TestITUantennasUIinput {
    public static final double peakGain = 15.0;
    public static final boolean usePeakGain = true;
    public static final Plane plane = Plane.HorizontalSymmetric;
    public static final boolean isInterferenceLink = false;
    public static final Distribution elevationCompensation = Factory.distributionFactory().getUniformDistribution(-90.0, 90.0);
    public static final double tilt = 0.0;
    public static final TiltModes tiltModeRec2 = TiltModes.ELECTRICAL_ONLY;
    public static final TiltModes tiltModeRec3 = TiltModes.MECHANICAL_ONLY;
    public static final Distribution additionalTilt = Factory.distributionFactory().getConstantDistribution(0.0);
    public static final double phi3 = 60.0;
    public static final OptionalValue<Double> theta3 = Factory.results().optional(false, 5.0);
    public static final OptionalValue<Distribution> fixAzi = Factory.results().optional(false, Factory.distributionFactory().getUniformDistribution(0.0, 360.0));
    public static final OptionalValue<Distribution> fixEle = Factory.results().optional(false, Factory.distributionFactory().getUniformDistribution(-90.0, 90.0));
    public static final double gran = 1.0;
    public static final AntennaSelection antennaToTest = AntennaSelection.F1336R3;
    public static final double frequency = 1000.0;
    public static final OptionalValue<Double> diameter = Factory.results().optional(false, 2.7);
    public static final OptionalValue<Double> apertureEfficiency = Factory.results().optional(false, 0.6);
    public static final boolean useAnnex1 = false;

    @Config(order=2, name="Peak gain", unit="dBi")
    public double peakGain();

    @Config(order=4, name="Consider the peak envelope", toolTip="not selected means average envelope")
    public boolean usePeakGain();

    @Config(order=6, name="Select plane")
    public Plane plane();

    @Config(order=8, name="   Apply Interference link", defineGroup="comp")
    public boolean isInterferenceLink();

    @Config(order=10, name="Elevation compensation", group="comp", unit="degree")
    public Distribution elevationCompensation();

    @Config(order=12, name="Tilt angle", unit="degree")
    public double tilt();

    @Config(order=14, name="Select tilt mode of 'Antenna elevation' for ITU-R F.1336-4 rec 2", toolTip="if 'Mechanical and electrical' is selected, the angle defined there is used additionally to the mechanically tilted 'Antenna elevation'")
    public TiltModes tiltModeRec2();

    @Config(order=15, name="Select tilt mode of 'Antenna elevation' for ITU-R F.1336-4 rec 3", toolTip="if 'Mechanical and electrical' is selected, the angle defined there is used additionally to the mechanically tilted 'Antenna elevation'")
    public TiltModes tiltModeRec3();

    @Config(order=16, name="Mechanical and electrical", defineGroup="mAnde", toolTip="applies the below angle electrically tilted to the mechanically tilted 'Antenna elevation' ")
    public boolean mAnde();

    @Config(order=18, name="Additional electrical tilt", group="mAnde", unit="degree")
    public Distribution additionalTilt();

    @Config(order=20, name="3 dB beamwidth in the azimuth plane", unit="degree")
    public double phi3();

    @Config(order=22, name="vertical beam width [NOTE 4]", unit="degree", toolTip="in case this value is known, it is recommended to use the known \u03b83 as an input parameter. ")
    public OptionalValue<Double> theta3();

    @Config(order=24, name="Fixed azimuth", unit="degree", toolTip="used for vertical pattern")
    public OptionalValue<Distribution> fixAzi();

    @Config(order=26, name="Fixed elevation", unit="degree", toolTip="used for horizontal pattern")
    public OptionalValue<Distribution> fixEle();

    @Config(order=28, name="Plot granularity", unit="degree")
    public double gran();

    @Config(order=0, name="Choose antenna for test")
    public AntennaSelection antennaToTest();

    @Config(order=50, name="Is ITU-R F.699 or ITU-R F.1245", defineGroup="fixed", toolTip="not selected applies 1000 MHz as default frequency")
    public boolean isForFixed();

    @Config(order=52, name="Antenna diameter", unit="m", group="fixed")
    public OptionalValue<Double> diameter();

    @Config(order=54, name="Aperture efficiency [0.35 ... 0.9]", group="fixed", toolTip="if this is deselected and the diameter is selected, the peak gain is calculated according to ITU-R P.699 recommends 3")
    public OptionalValue<Double> apertureEfficiency();

    @Config(order=56, name="Consider Annex 1 in terms of antennas for use in statistical interference assessment", group="fixed")
    public boolean useAnnex1();

    @Config(order=51, name="Frequency", unit="MHz", group="fixed", toolTip="required only for ITU-R F.699 and ITU-R F.1245")
    public double frequency();

    public static enum AntennaSelection {
        F1336R2("ITU-R F.1336-4 rec 2"),
        F1336R3("ITU-R F.1336-4 rec 3"),
        F699("ITU-R F.699-7"),
        F1245("ITU-R F-1245-2");

        private final String name;

        private AntennaSelection(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }

    public static enum Plane {
        HorizontalSimulated,
        HorizontalSymmetric,
        Vertical;

    }
}

