/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.eventprocessing.ituantennas;

import java.util.ArrayList;
import java.util.List;
import org.seamcat.eventprocessing.ituantennas.TestITUantennasUI;
import org.seamcat.model.Scenario;
import org.seamcat.model.factory.Factory;
import org.seamcat.model.plugin.antenna.ITU_R_F1245Input;
import org.seamcat.model.plugin.antenna.ITU_R_F1336_4_rec_2_Input;
import org.seamcat.model.plugin.antenna.ITU_R_F1336_4_rec_3_Input;
import org.seamcat.model.plugin.antenna.ITU_R_F699Input;
import org.seamcat.model.plugin.eventprocessing.EventProcessingPlugin;
import org.seamcat.model.plugin.eventprocessing.PostProcessingTab;
import org.seamcat.model.plugin.eventprocessing.PostProcessingUI;
import org.seamcat.model.plugin.system.ConsistencyCheckContext;
import org.seamcat.model.simulation.consistency.Validator;
import org.seamcat.model.simulation.result.Collector;
import org.seamcat.model.simulation.result.EventResult;
import org.seamcat.model.simulation.result.InterferenceLinkResult;
import org.seamcat.model.simulation.result.LinkResult;
import org.seamcat.model.types.Description;
import org.seamcat.model.types.InterferenceLink;
import org.seamcat.model.types.result.DescriptionImpl;
import org.seamcat.simulation.generic.CognitiveRadio;
import org.seamcat.simulation.generic.GenericSystemPlugin;
import org.seamcat.simulation.result.SensingLinkResult;

public class DemoEPP_12_TestITUantennas
implements EventProcessingPlugin<Input>,
PostProcessingTab {
    @Override
    public void evaluate(Scenario scenario, EventResult eventResult, Input input, Collector collector) {
        String vlr = "VLR";
        String ilt = "ILT";
        collector.add(Factory.results().group(vlr, "azimuth VLR - VLT", "degree"), eventResult.getVictimResult().getVictims().get(0).getLinkResult().rxAntenna().getAzimuth());
        collector.add(Factory.results().group(vlr, "elevation VLR - VLT", "degree"), eventResult.getVictimResult().getVictims().get(0).getLinkResult().rxAntenna().getElevation());
        collector.add(Factory.results().group(vlr, "tilt VLR - VLT", "degree"), eventResult.getVictimResult().getVictims().get(0).getLinkResult().rxAntenna().getTilt());
        collector.add(Factory.results().group(vlr, "elevation compensation VLR - VLT", "degree"), eventResult.getVictimResult().getVictims().get(0).getLinkResult().rxAntenna().getElevationCompensation());
        collector.add(Factory.results().group(vlr, "antenna gain VLR - VLT", "dBi"), eventResult.getVictimResult().getVictims().get(0).getLinkResult().rxAntenna().getGain());
        for (InterferenceLink link : scenario.getInterferenceLinks()) {
            LinkResult extraLink;
            InterferenceLinkResult linkResult = eventResult.getInterferenceLinkResult(link).get(0);
            String linkKey = link.getInterferer().getName();
            collector.add(Factory.results().group(vlr, "azimuth VLR - ILT_" + linkKey, "degree"), linkResult.rxAntenna().getAzimuth());
            collector.add(Factory.results().group(vlr, "elevation VLR - ILT_" + linkKey, "degree"), linkResult.rxAntenna().getElevation());
            collector.add(Factory.results().group(vlr, "antenna gain VLR - ILT_" + linkKey, "dBi"), linkResult.rxAntenna().getGain());
            collector.add(Factory.results().group(ilt, linkKey + " azimuth ILT - VLR", "degree"), linkResult.txAntenna().getAzimuth());
            collector.add(Factory.results().group(ilt, linkKey + " elevation ILT - VLR", "degree"), linkResult.txAntenna().getElevation());
            collector.add(Factory.results().group(ilt, linkKey + " tilt ILT - ILR", "degree"), linkResult.txAntenna().getTilt());
            collector.add(Factory.results().group(ilt, linkKey + " elevation compensation ILT - ILR", "degree"), linkResult.txAntenna().getElevationCompensation());
            collector.add(Factory.results().group(ilt, linkKey + " antenna gain ILT - ILR", "degree"), linkResult.txAntenna().getGain());
            List<LinkResult> extralinks = linkResult.getInterferingSystemResult().getLinkResults(CognitiveRadio.SENSING_LINK);
            if (extralinks == null || extralinks.isEmpty() || !((extraLink = extralinks.get(0)) instanceof SensingLinkResult)) continue;
            SensingLinkResult sensing = (SensingLinkResult)extraLink;
            collector.add(Factory.results().group(ilt, linkKey + " azimuth ILT - VLT", "degree"), sensing.rxAntenna().getAzimuth());
            collector.add(Factory.results().group(ilt, linkKey + " elevation ILT - VLT", "degree"), sensing.rxAntenna().getElevation());
            collector.add(Factory.results().group(ilt, linkKey + " elevation compensation ILT - VLT", "degree"), sensing.rxAntenna().getElevationCompensation());
            collector.add(Factory.results().group(ilt, linkKey + " antenna gain ILT - VLT", "dBi"), sensing.rxAntenna().getGain());
            collector.add(Factory.results().group(ilt, linkKey + " azimuth VLT - ILT", "degree"), sensing.txAntenna().getAzimuth());
            collector.add(Factory.results().group(ilt, linkKey + " elevation VLT - ILT", "degree"), sensing.txAntenna().getElevation());
            collector.add(Factory.results().group(ilt, linkKey + " elevation compensation VLT - ILT", "degree"), sensing.txAntenna().getElevationCompensation());
            collector.add(Factory.results().group(ilt, linkKey + " antenna gain  VLT - ILT", "dBi"), sensing.txAntenna().getGain());
        }
    }

    @Override
    public void consistencyCheck(ConsistencyCheckContext context, Input input, Validator validator) {
        String msg = "<HtMl><b style= 'color: red;'>This will prevent the EPP from working correctly. ";
        Scenario scenario = context.getScenario();
        if (!(scenario.getVictim().getSystemPlugin() instanceof GenericSystemPlugin)) {
            validator.error("<HtMl></br>Only Generic Systems allowed as victim" + msg);
        }
        if (!(scenario.getInterferenceLinks().get(0).getInterferer().getSystemPlugin() instanceof GenericSystemPlugin)) {
            validator.error("<HtMl></br>Only Generic Systems allowed as interferer" + msg);
        }
        if (!(scenario.getVictim().getSystem().getReceiver().getAntennaGain().getModel() instanceof ITU_R_F1336_4_rec_2_Input)) {
            validator.error("<HtMl></br>Please set ITU-R F.1336-4 rec 2 to the VLR " + msg);
        }
        if (!(scenario.getVictim().getSystem().getTransmitter().getAntennaGain().getModel() instanceof ITU_R_F1336_4_rec_3_Input)) {
            validator.error("<HtMl></br>Please set ITU-R F.1336-4 rec 3 to the VLT " + msg);
        }
        if (!(scenario.getInterferenceLinks().get(0).getInterferer().getSystem().getReceiver().getAntennaGain().getModel() instanceof ITU_R_F699Input)) {
            validator.error("<HtMl></br>Please set ITU-R F.699-7 to the ILR " + msg);
        }
        if (!(scenario.getInterferenceLinks().get(0).getInterferer().getSystem().getTransmitter().getAntennaGain().getModel() instanceof ITU_R_F1245Input)) {
            validator.error("<HtMl></br>Please set ITU-R F-1245-2 to the ILT " + msg);
        }
    }

    @Override
    public Description description() {
        return new DescriptionImpl("Demo 12: Test ITU Antennas", "<HtMl>Please set<ul><li>ITU-R F.1336-4 rec 2 to the VLR</li><li>ITU-R F.1336-4 rec 3 to the VLT</li><li>ITU-R F.699-7 to the  first ILR</li><li>ITU-R F.1245-2 to the first ILT</li></ul>and configure these antennas according to your requirements.<br/><i>Note that this is used  only for the antenna testing.</i><br/><em style= 'color: red;'>You may ignore the consistency warnings concerning antenna heights and the frequency.</em><br/><br/>This EPP puts also simulated angles of the vicitm link and the interference link to the result panel.");
    }

    @Override
    public List<Class<? extends PostProcessingUI>> tabs() {
        ArrayList<Class<? extends PostProcessingUI>> tabs = new ArrayList<Class<? extends PostProcessingUI>>();
        tabs.add(TestITUantennasUI.class);
        return tabs;
    }

    public static interface Input {
    }
}

