/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.eventprocessing.im3broadband;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Locale;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import org.seamcat.eventprocessing.im3broadband.EPPforIM3;
import org.seamcat.eventprocessing.im3broadband.IM3ValueDefinitions;
import org.seamcat.eventprocessing.im3broadband.PanelForInfo;
import org.seamcat.model.Scenario;
import org.seamcat.model.factory.Factory;
import org.seamcat.model.geometry.Point2D;
import org.seamcat.model.mathematics.Mathematics;
import org.seamcat.model.plugin.Config;
import org.seamcat.model.plugin.OptionalValue;
import org.seamcat.model.plugin.eventprocessing.ModelPanel;
import org.seamcat.model.plugin.eventprocessing.PanelDefinition;
import org.seamcat.model.plugin.eventprocessing.Panels;
import org.seamcat.model.plugin.eventprocessing.PostProcessing;
import org.seamcat.model.plugin.eventprocessing.PostProcessingUI;
import org.seamcat.model.simulation.result.SimulationResult;
import org.seamcat.model.simulation.result.UniqueValueDef;
import org.seamcat.model.simulation.result.VectorDef;
import org.seamcat.model.types.EventProcessing;
import org.seamcat.model.types.result.DoubleResultType;
import org.seamcat.model.types.result.Results;
import org.seamcat.model.types.result.ScatterDiagramResultType;
import org.seamcat.model.types.result.VectorResultType;
import org.seamcat.simulation.generic.GenericSystemPlugin;

public class EPPforIM3_PPUI
implements PostProcessingUI {
    private final JPanel panelPlot = new JPanel(new BorderLayout());
    private Panels panels;
    private PanelForInfo panelInfo;
    private double sensitivity;
    private double protectionLimit;
    private ModelPanel<North> panelInput;
    private DecimalFormat df;
    private double noiseFloor;
    private boolean ready;
    private Locale loc;

    @Override
    public String getTitle() {
        return "Intermodulation (Broadband) EPP";
    }

    @Override
    public void buildUI(Scenario scenario, JPanel canvas, Panels panels) {
        this.panels = panels;
        this.panelInfo = new PanelForInfo();
        canvas.setLayout(new BorderLayout());
        canvas.add((Component)panels.get("Configure parameters").getPanel(), "North");
        canvas.add((Component)this.panelInfo, "West");
        canvas.add((Component)this.panelPlot, "Center");
    }

    @Override
    public PanelDefinition[] panelDefinitions() {
        return new PanelDefinition[]{new PanelDefinition<North>("Configure parameters", North.class)};
    }

    private void setNoiseFloor(double noiseFloor) {
        this.noiseFloor = noiseFloor;
    }

    private boolean isReady() {
        return this.ready;
    }

    private void setReady(boolean ready) {
        this.ready = ready;
    }

    @PostProcessing(order=1, name="Generate plot")
    public void showPlot(Scenario scenario, Results results, SimulationResult simulationResult, EPPforIM3.Input input) {
        this.initPlugin(scenario, results);
        EventProcessing epp = Factory.eventProcessors().getByClass(EPPforIM3.class);
        Results pResult = null;
        for (int i = 0; i < scenario.getEventProcessingList().size(); ++i) {
            if (!simulationResult.getResult(scenario.getEventProcessingList().get(i)).getName().contains(epp.description().name())) continue;
            pResult = simulationResult.getResult(scenario.getEventProcessingList().get(i));
            break;
        }
        VectorResultType dRSS = pResult.findVector(IM3ValueDefinitions.getDefinitionDRSS());
        VectorResultType iRSSunw = pResult.findVector(IM3ValueDefinitions.getDefinitionUnwanted("summation"));
        VectorResultType iRSSblock = pResult.findVector(IM3ValueDefinitions.getDefinitionBlocking("summation"));
        VectorResultType im3 = pResult.findVector(IM3ValueDefinitions.getDefinitionIM3("summation"));
        VectorResultType noise = pResult.findVector(IM3ValueDefinitions.getDefinitionNoiseFloor());
        ScatterDiagramResultType positionsVLR = pResult.findScatterDiagram(IM3ValueDefinitions.getDefinitionScatterVLR());
        this.panelPlot.removeAll();
        XYSeries outIM3 = new XYSeries((Comparable)((Object)"outage due to IM3"));
        XYSeries outBlock = new XYSeries((Comparable)((Object)"outage due to blocking"));
        XYSeries outOoB = new XYSeries((Comparable)((Object)"outage due to OoB"));
        int eventsGreaterSens = 0;
        int eventsOoB = 0;
        int eventBlock = 0;
        int eventsIM3 = 0;
        int eventCombined = 0;
        ArrayList<Double> lIM3 = new ArrayList<Double>();
        ArrayList<Double> lUNW = new ArrayList<Double>();
        ArrayList<Double> lBLOCK = new ArrayList<Double>();
        ArrayList<Double> lSUM = new ArrayList<Double>();
        block6: for (int i = 0; i < dRSS.getValue().size(); ++i) {
            if (!(dRSS.getValue().asArray()[i] >= this.sensitivity)) continue;
            ++eventsGreaterSens;
            double tDRSS = dRSS.getValue().asArray()[i];
            double tNoiseFloor = noise.getValue().asArray()[i];
            if (this.panelInput.getModel().noiseFloor().isRelevant()) {
                tNoiseFloor = this.noiseFloor;
            }
            switch (this.panelInput.getModel().criterion()) {
                case CI: {
                    double pIM3 = tDRSS - im3.getValue().asArray()[i];
                    double pUNW = tDRSS - iRSSunw.getValue().asArray()[i];
                    double pBLOCK = tDRSS - iRSSblock.getValue().asArray()[i];
                    lIM3.add(pIM3);
                    lUNW.add(pUNW);
                    lBLOCK.add(pBLOCK);
                    if (pIM3 < this.protectionLimit) {
                        ++eventsIM3;
                        outIM3.add(((Point2D)positionsVLR.value().get(i)).getX(), ((Point2D)positionsVLR.value().get(i)).getY());
                    }
                    if (pUNW < this.protectionLimit) {
                        ++eventsOoB;
                        outOoB.add(((Point2D)positionsVLR.value().get(i)).getX(), ((Point2D)positionsVLR.value().get(i)).getY());
                    }
                    if (pBLOCK < this.protectionLimit) {
                        ++eventBlock;
                        outBlock.add(((Point2D)positionsVLR.value().get(i)).getX(), ((Point2D)positionsVLR.value().get(i)).getY());
                    }
                    double[] dArray = new double[]{im3.getValue().asArray()[i], iRSSunw.getValue().asArray()[i], iRSSblock.getValue().asArray()[i]};
                    double iTotal = Mathematics.powerSummation(dArray);
                    if (tDRSS - iTotal < this.protectionLimit) {
                        ++eventCombined;
                    }
                    lSUM.add(tDRSS - iTotal);
                    continue block6;
                }
                case IN: {
                    double pIM3 = im3.getValue().asArray()[i] - tNoiseFloor;
                    double pUNW = iRSSunw.getValue().asArray()[i] - tNoiseFloor;
                    double pBLOCK = iRSSblock.getValue().asArray()[i] - tNoiseFloor;
                    lIM3.add(pIM3);
                    lUNW.add(pUNW);
                    lBLOCK.add(pBLOCK);
                    if (im3.getValue().asArray()[i] - tNoiseFloor > this.protectionLimit) {
                        ++eventsIM3;
                        outIM3.add(((Point2D)positionsVLR.value().get(i)).getX(), ((Point2D)positionsVLR.value().get(i)).getY());
                    }
                    if (iRSSunw.getValue().asArray()[i] - tNoiseFloor > this.protectionLimit) {
                        ++eventsOoB;
                        outOoB.add(((Point2D)positionsVLR.value().get(i)).getX(), ((Point2D)positionsVLR.value().get(i)).getY());
                    }
                    if (iRSSblock.getValue().asArray()[i] - tNoiseFloor > this.protectionLimit) {
                        ++eventBlock;
                        outBlock.add(((Point2D)positionsVLR.value().get(i)).getX(), ((Point2D)positionsVLR.value().get(i)).getY());
                    }
                    double[] dArray = new double[]{im3.getValue().asArray()[i], iRSSunw.getValue().asArray()[i], iRSSblock.getValue().asArray()[i]};
                    double iTotal = Mathematics.powerSummation(dArray);
                    if (iTotal - tNoiseFloor > this.protectionLimit) {
                        ++eventCombined;
                    }
                    lSUM.add(iTotal - tNoiseFloor);
                    continue block6;
                }
                case NIN: {
                    double pIM3 = Mathematics.powerSummation(im3.getValue().asArray()[i], tNoiseFloor) - tNoiseFloor;
                    double pUNW = Mathematics.powerSummation(iRSSunw.getValue().asArray()[i], tNoiseFloor) - tNoiseFloor;
                    double pBLOCK = Mathematics.powerSummation(iRSSblock.getValue().asArray()[i], tNoiseFloor) - tNoiseFloor;
                    lIM3.add(pIM3);
                    lUNW.add(pUNW);
                    lBLOCK.add(pBLOCK);
                    double[] dArray = new double[]{im3.getValue().asArray()[i], tNoiseFloor};
                    if (Mathematics.powerSummation(dArray) - tNoiseFloor > this.protectionLimit) {
                        ++eventsIM3;
                        outIM3.add(((Point2D)positionsVLR.value().get(i)).getX(), ((Point2D)positionsVLR.value().get(i)).getY());
                    }
                    double[] dArray2 = new double[]{iRSSunw.getValue().asArray()[i], tNoiseFloor};
                    if (Mathematics.powerSummation(dArray2) - tNoiseFloor > this.protectionLimit) {
                        ++eventsOoB;
                        outOoB.add(((Point2D)positionsVLR.value().get(i)).getX(), ((Point2D)positionsVLR.value().get(i)).getY());
                    }
                    double[] dArray3 = new double[]{iRSSblock.getValue().asArray()[i], tNoiseFloor};
                    if (Mathematics.powerSummation(dArray3) - tNoiseFloor > this.protectionLimit) {
                        ++eventBlock;
                        outBlock.add(((Point2D)positionsVLR.value().get(i)).getX(), ((Point2D)positionsVLR.value().get(i)).getY());
                    }
                    double[] dArray4 = new double[]{im3.getValue().asArray()[i], iRSSunw.getValue().asArray()[i], iRSSblock.getValue().asArray()[i], tNoiseFloor};
                    double iTotal = Mathematics.powerSummation(dArray4);
                    if (iTotal - tNoiseFloor > this.protectionLimit) {
                        ++eventCombined;
                    }
                    lSUM.add(iTotal - tNoiseFloor);
                    continue block6;
                }
                default: {
                    double pIM3 = tDRSS - Mathematics.powerSummation(im3.getValue().asArray()[i], tNoiseFloor);
                    double pUNW = tDRSS - Mathematics.powerSummation(iRSSunw.getValue().asArray()[i], tNoiseFloor);
                    double pBLOCK = tDRSS - Mathematics.powerSummation(iRSSblock.getValue().asArray()[i], tNoiseFloor);
                    lIM3.add(pIM3);
                    lUNW.add(pUNW);
                    lBLOCK.add(pBLOCK);
                    double[] dArray = new double[]{im3.getValue().asArray()[i], tNoiseFloor};
                    if (tDRSS - Mathematics.powerSummation(dArray) < this.protectionLimit) {
                        ++eventsIM3;
                        outIM3.add(((Point2D)positionsVLR.value().get(i)).getX(), ((Point2D)positionsVLR.value().get(i)).getY());
                    }
                    double[] dArray5 = new double[]{iRSSunw.getValue().asArray()[i], tNoiseFloor};
                    if (tDRSS - Mathematics.powerSummation(dArray5) < this.protectionLimit) {
                        ++eventsOoB;
                        outOoB.add(((Point2D)positionsVLR.value().get(i)).getX(), ((Point2D)positionsVLR.value().get(i)).getY());
                    }
                    double[] dArray6 = new double[]{iRSSblock.getValue().asArray()[i], tNoiseFloor};
                    if (tDRSS - Mathematics.powerSummation(dArray6) < this.protectionLimit) {
                        ++eventBlock;
                        outBlock.add(((Point2D)positionsVLR.value().get(i)).getX(), ((Point2D)positionsVLR.value().get(i)).getY());
                    }
                    double[] dArray7 = new double[]{im3.getValue().asArray()[i], iRSSunw.getValue().asArray()[i], iRSSblock.getValue().asArray()[i], tNoiseFloor};
                    double iTotal = Mathematics.powerSummation(dArray7);
                    if (tDRSS - iTotal < this.protectionLimit) {
                        ++eventCombined;
                    }
                    lSUM.add(tDRSS - iTotal);
                }
            }
        }
        String group = String.format(this.loc, "%s_%2.1f dB", this.panelInput.getModel().criterion().toString(), this.protectionLimit);
        VectorDef def = null;
        if (results.findGroup(group).size() == 0) {
            def = Factory.results().group(group, "IM3", "dB");
            results.getVectorResultTypes().add(new VectorResultType(def, lIM3));
            def = Factory.results().group(group, "UNWANTED", "dB");
            results.getVectorResultTypes().add(new VectorResultType(def, lUNW));
            def = Factory.results().group(group, "BLOCKING", "dB");
            results.getVectorResultTypes().add(new VectorResultType(def, lBLOCK));
            def = Factory.results().group(group, "COMBINED", "dB");
            results.getVectorResultTypes().add(new VectorResultType(def, lSUM));
        }
        double outProbabIM3 = (double)eventsIM3 / (double)eventsGreaterSens * 100.0;
        double outProbabBlock = (double)eventBlock / (double)eventsGreaterSens * 100.0;
        double outProbabOoB = (double)eventsOoB / (double)eventsGreaterSens * 100.0;
        double outProbabCombined = (double)eventCombined / (double)eventsGreaterSens * 100.0;
        this.setResultsToPanel(outProbabIM3, outProbabOoB, outProbabBlock, eventsGreaterSens, this.panelInput.getModel());
        this.panelInfo.getTextFieldCombined().setText(this.df.format(outProbabCombined) + " %");
        UniqueValueDef singleDef = Factory.results().singleGroup("Probability of exceeding the protection criterion ", "Intermodulation (broadband) " + group, "%");
        if (!results.getSingleValueTypes().contains(singleDef)) {
            results.getSingleValueTypes().add(new DoubleResultType(singleDef, outProbabIM3));
        }
        if (this.isReady()) {
            XYSeriesCollection dataset = new XYSeriesCollection();
            int selected = this.panelInfo.getSelectMechanism().getSelectedIndex();
            if (selected == 4) {
                dataset.addSeries(outIM3);
                dataset.addSeries(outOoB);
                dataset.addSeries(outBlock);
            } else if (selected == 1) {
                dataset.addSeries(outOoB);
            } else if (selected == 2) {
                dataset.addSeries(outBlock);
            } else {
                dataset.addSeries(outIM3);
            }
            JFreeChart dRSSchart = ChartFactory.createScatterPlot("Positions of impacted VLR ", "pos x [km]", "pos y [km]", dataset, PlotOrientation.VERTICAL, true, true, false);
            dRSSchart.fireChartChanged();
            XYPlot plot = (XYPlot)dRSSchart.getPlot();
            if (selected == 4) {
                plot.getRenderer().setSeriesPaint(0, Color.RED);
                plot.getRenderer().setSeriesPaint(1, Color.CYAN);
                plot.getRenderer().setSeriesPaint(2, Color.BLUE);
            } else {
                plot.getRenderer().setSeriesPaint(0, Color.BLUE);
            }
            ChartPanel cp = new ChartPanel(dRSSchart);
            cp.repaint();
            this.panelPlot.add((Component)cp, "Center");
            this.panelPlot.revalidate();
            this.panelPlot.repaint();
        }
    }

    private void setResultsToPanel(double outProbabIM3, double outProbabOoB, double outProbabBlcck, int eventsGreaterSens, North input) {
        this.panelInfo.getTextFieldEvents().setText(String.valueOf(eventsGreaterSens));
        this.panelInfo.getTextFieldIM3().setText(this.df.format(outProbabIM3) + " %");
        this.panelInfo.getTextFieldUnwanted().setText(this.df.format(outProbabOoB) + " %");
        this.panelInfo.getTextFieldBlocking().setText(this.df.format(outProbabBlcck) + " %");
        this.panelInfo.getTextFieldCriterion().setText(input.criterion().toString());
    }

    private void initPlugin(Scenario scenario, Results results) {
        this.panelInput = this.panels.get("Configure parameters");
        North input = this.panelInput.getModel();
        this.loc = new Locale("US");
        this.df = (DecimalFormat)DecimalFormat.getInstance(Locale.US);
        this.df.applyPattern("###0.0#");
        GenericSystemPlugin rs = (GenericSystemPlugin)scenario.getVictim().getSystemPlugin();
        this.setSensitivity(rs.getSensitivity());
        if (input.sensitivity().isRelevant()) {
            this.setSensitivity(input.sensitivity().getValue());
        }
        if (input.noiseFloor().isRelevant()) {
            this.setNoiseFloor(input.noiseFloor().getValue());
        }
        if (input.protectionLimit().isRelevant()) {
            this.setProtectionLimit(input.protectionLimit().getValue());
        } else {
            switch (input.criterion()) {
                case CI: {
                    this.setProtectionLimit(rs.getProtectionRatio());
                    break;
                }
                case NIN: {
                    this.setProtectionLimit(rs.getNoiseAugmentation());
                    break;
                }
                case IN: {
                    this.setProtectionLimit(rs.getInterferenceToNoiseRatio());
                    break;
                }
                default: {
                    this.setProtectionLimit(rs.getExtendedProtectionRatio());
                }
            }
        }
        int selected = this.panelInfo.getSelectMechanism().getSelectedIndex();
        if (selected == 0) {
            this.setReady(false);
            this.popupDialog("Please select a valid interference mechanism");
        } else {
            this.setResultColors();
            this.setReady(true);
        }
    }

    private void setResultColors() {
        this.panelInfo.getTextFieldBlocking().setForeground(Color.BLUE);
        this.panelInfo.getTextFieldIM3().setForeground(Color.RED);
        this.panelInfo.getTextFieldUnwanted().setForeground(Color.CYAN);
    }

    private void popupDialog(String msg) {
        JOptionPane.showMessageDialog(null, msg, "IM3", 1);
    }

    private void setSensitivity(double sensitivity) {
        this.sensitivity = sensitivity;
    }

    private void setProtectionLimit(double protectionLimit) {
        this.protectionLimit = protectionLimit;
    }

    public static interface North {
        public static final IM3ValueDefinitions.Criterion criterion = IM3ValueDefinitions.Criterion.CNI;
        public static final OptionalValue<Double> protectionLimit = Factory.results().optional(false, 19.0);
        public static final OptionalValue<Double> sensitivity = Factory.results().optional(false, -82.0);
        public static final OptionalValue<Double> noiseFloor = Factory.results().optional(false, -125.0);

        @Config(order=1, name="Select protection criterion")
        public IM3ValueDefinitions.Criterion criterion();

        @Config(order=3, name="Value for protection criterion", unit="dB", toolTip="overrides workspace settings")
        public OptionalValue<Double> protectionLimit();

        @Config(order=5, name="Sensitivity", unit="dBm", toolTip="overrides workspace settings")
        public OptionalValue<Double> sensitivity();

        @Config(order=7, name="noise floor", unit="dBm", toolTip="overrides workspace settings")
        public OptionalValue<Double> noiseFloor();
    }
}

