/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.eventprocessing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Random;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import org.seamcat.model.Scenario;
import org.seamcat.model.factory.Factory;
import org.seamcat.model.functions.Function;
import org.seamcat.model.geometry.Point2D;
import org.seamcat.model.plugin.Config;
import org.seamcat.model.plugin.eventprocessing.PanelDefinition;
import org.seamcat.model.plugin.eventprocessing.Panels;
import org.seamcat.model.plugin.eventprocessing.PostProcessing;
import org.seamcat.model.plugin.eventprocessing.PostProcessingUI;
import org.seamcat.model.simulation.result.VectorDef;
import org.seamcat.model.types.AntennaGain;
import org.seamcat.model.types.PropagationModel;
import org.seamcat.model.types.result.BarChartResultType;
import org.seamcat.model.types.result.BarChartValue;
import org.seamcat.model.types.result.Results;
import org.seamcat.model.types.result.ScatterDiagramResultType;
import org.seamcat.model.types.result.VectorResultType;
import org.seamcat.presentation.MainWindow;
import org.seamcat.presentation.display.VectorGroupResultType;

public class ExampleCustomUIEPP
implements PostProcessingUI {
    private Panels panels;

    @Override
    public PanelDefinition[] panelDefinitions() {
        return new PanelDefinition[]{new PanelDefinition<Left>("Parameters", Left.class), new PanelDefinition<Right>("Propagation Model", Right.class)};
    }

    @Override
    public String getTitle() {
        return "Result types generator";
    }

    @Override
    public void buildUI(Scenario scenario, JPanel canvas, Panels panels) {
        this.panels = panels;
        JSplitPane split = new JSplitPane(1);
        split.add(panels.get("Parameters").getPanel());
        split.add(panels.get("Propagation Model").getPanel());
        canvas.setLayout(new BorderLayout());
        canvas.add((Component)split, "Center");
    }

    private void popupDialog(String type) {
        JOptionPane.showMessageDialog(MainWindow.getInstance(), "Created random " + type + ". See the value in Results tab", "Result generated", 1);
    }

    @PostProcessing(order=1, name="Scatter")
    public void scatter(Scenario scenario, Results allResults) {
        ScatterDiagramResultType type = new ScatterDiagramResultType(Factory.results().multi("Scatter", "x", "y"));
        Random random = new Random();
        for (int i = 0; i < 25; ++i) {
            type.value().add(new Point2D(i, (double)i * random.nextDouble()));
        }
        allResults.getScatterDiagramResultTypes().add(type);
        this.popupDialog("scatter plot");
    }

    @PostProcessing(order=2, name="Bar chart")
    public void bar(Scenario scenario, Results allResults) {
        BarChartResultType type = new BarChartResultType(Factory.results().multi("Bar chart", "x", "y"));
        Random random = new Random();
        for (int i = 0; i < 10; ++i) {
            type.value().add(new BarChartValue("" + i, (double)i * random.nextDouble()));
        }
        allResults.getBarChartResultTypes().add(type);
        this.popupDialog("bar chart");
    }

    @PostProcessing(order=3, name="Vector Group")
    public void vectorGroup(Scenario scenario, Results allResults) {
        VectorGroupResultType type = new VectorGroupResultType("Vector group", "dBm");
        Random random = new Random();
        for (int i = 0; i < 4; ++i) {
            ArrayList<Double> vector = new ArrayList<Double>();
            for (int j = 0; j < 150; ++j) {
                vector.add(random.nextDouble());
            }
            VectorDef def = Factory.results().group("Vector group", "Vector " + (i + 1), "dBm");
            allResults.getVectorResultTypes().add(new VectorResultType(def, vector));
        }
        this.popupDialog("vector group");
    }

    public static interface Right {
        @Config(order=1, name="Propagation")
        public PropagationModel pm();
    }

    public static interface Left {
        @Config(order=1, name="Value")
        public double value();

        @Config(order=2, name="Function")
        public Function function();

        @Config(order=3, name="Antenna")
        public AntennaGain antenna();
    }
}

