/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.eventprocessing;

import java.util.Map;
import org.seamcat.model.Scenario;
import org.seamcat.model.factory.Factory;
import org.seamcat.model.plugin.Empty;
import org.seamcat.model.plugin.eventprocessing.EventProcessingPlugin;
import org.seamcat.model.plugin.system.ConsistencyCheckContext;
import org.seamcat.model.simulation.consistency.Validator;
import org.seamcat.model.simulation.result.Collector;
import org.seamcat.model.simulation.result.EventResult;
import org.seamcat.model.simulation.result.InterferenceLinkResult;
import org.seamcat.model.simulation.result.LinkResult;
import org.seamcat.model.simulation.result.UniqueValueDef;
import org.seamcat.model.types.Description;
import org.seamcat.model.types.InterferenceLink;
import org.seamcat.model.types.Unit;
import org.seamcat.model.types.result.DescriptionImpl;
import org.seamcat.simulation.generic.GenericSystemPlugin;
import org.seamcat.simulation.generic.Intermodulation;

public class DemoEPP_9_Intermod
implements EventProcessingPlugin<Empty> {
    private boolean isPassed = true;

    @Override
    public void evaluate(Scenario scenario, EventResult event, Empty input, Collector collector) {
        if (this.isPassed) {
            String group = "Intermodulation internals";
            LinkResult victimLink = event.getVictimResult().getVictims().get(0).getLinkResult();
            int i = 1;
            for (Map.Entry<UniqueValueDef, Double> entry : victimLink.getDoubleValues().entrySet()) {
                if (!entry.getKey().name().startsWith("victim intermodulation response")) continue;
                collector.add(Factory.results().group(group, entry.getKey().name(), Unit.dBm.name()), (double)entry.getValue());
            }
            for (InterferenceLink link : scenario.getInterferenceLinks()) {
                for (InterferenceLinkResult iLink : event.getInterferenceLinkResult(link)) {
                    String name = Intermodulation.IRSS + " " + i;
                    collector.add(Factory.results().group(group, name, Unit.dBm.name()), (double)((Double)iLink.getValue(Intermodulation.IRSS)));
                    ++i;
                }
            }
        }
    }

    @Override
    public void consistencyCheck(ConsistencyCheckContext context, Empty input, Validator validator) {
        Scenario scenario = context.getScenario();
        if (!(scenario.getVictim().getSystemPlugin() instanceof GenericSystemPlugin)) {
            validator.error("<HtMl><br/><b>" + scenario.getVictim().getName() + ": </b>only generic systems are applicable as victim. <i style= 'color: red'>This EPP will be ignored.</i>");
            this.setIsPassed(false);
        }
        for (InterferenceLink link : scenario.getInterferenceLinks()) {
            if (link.getInterferer().getSystemPlugin() instanceof GenericSystemPlugin) continue;
            validator.error("<HtMl><br/><b>" + link.getInterferer().getName() + ": </b>only generic systems are applicable as interferer. <i style= 'color: red'>This EPP will be ignored.</i>");
            this.setIsPassed(false);
        }
    }

    @Override
    public Description description() {
        return new DescriptionImpl("Demo 9: Intermodulation internals", "<html>Collect intermediate variables of the <br>intermodulation calculation</html>");
    }

    public void setIsPassed(boolean isPassed) {
        this.isPassed = isPassed;
    }
}

