/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.eventprocessing;

import java.util.List;
import org.seamcat.model.Scenario;
import org.seamcat.model.factory.Factory;
import org.seamcat.model.geometry.Point2D;
import org.seamcat.model.mathematics.Mathematics;
import org.seamcat.model.plugin.Config;
import org.seamcat.model.plugin.eventprocessing.EventProcessingPlugin;
import org.seamcat.model.plugin.system.ConsistencyCheckContext;
import org.seamcat.model.simulation.consistency.Validator;
import org.seamcat.model.simulation.result.Collector;
import org.seamcat.model.simulation.result.EventResult;
import org.seamcat.model.simulation.result.InterferenceLinkResult;
import org.seamcat.model.types.Description;
import org.seamcat.model.types.InterferenceLink;
import org.seamcat.model.types.result.DescriptionImpl;
import org.seamcat.simulation.generic.GenericSystemPlugin;

public class DemoEPP_8_Distance
implements EventProcessingPlugin<Input> {
    private double maxD1 = 0.0;
    private double maxD2 = 0.0;

    @Override
    public void evaluate(Scenario scenario, EventResult result, Input input, Collector collector) {
        int modFactor = 1;
        this.maxD1 = 0.0;
        this.maxD2 = 0.0;
        if (!(scenario.getVictim().getSystemPlugin() instanceof GenericSystemPlugin)) {
            modFactor = 3;
        }
        for (InterferenceLink link : scenario.getInterferenceLinks()) {
            if (result.getInterferenceLinkResult(link).size() <= 200) continue;
            modFactor *= 100;
        }
        collector.add(Factory.results().value("Distance between the victim system RX and TX", "km"), result.getVictimResult().getVictims().get(0).getLinkResult().getTxRxDistance());
        List<InterferenceLink> interferenceLinks = scenario.getInterferenceLinks();
        for (int i1 = 0; i1 < interferenceLinks.size(); ++i1) {
            InterferenceLink link = interferenceLinks.get(i1);
            String key = "Link " + i1 + " (" + link.getInterferer().getName() + ") ";
            for (int i = 0; i < result.getInterferenceLinkResult(link).size(); ++i) {
                InterferenceLinkResult subLinkResult = result.getInterferenceLinkResult(link).get(i);
                if (!(scenario.getVictim().getSystemPlugin() instanceof GenericSystemPlugin)) {
                    key = subLinkResult.getInterferenceLink().getVictim().getName();
                }
                Point2D posILT = subLinkResult.txAntenna().getPosition();
                Point2D posVLR = subLinkResult.rxAntenna().getPosition();
                Point2D posVLT = subLinkResult.getVictimSystemLink().txAntenna().getPosition();
                Point2D posILR = subLinkResult.getInterferingSystemLink().rxAntenna().getPosition();
                double d1 = Mathematics.distance(posVLR, posILT);
                double d2 = Mathematics.distance(posVLT, posILT);
                if (d1 > this.maxD1) {
                    this.maxD1 = d1;
                }
                if (d2 > this.maxD2) {
                    this.maxD2 = d2;
                }
                if (i % modFactor == 0 && input.showDetails()) {
                    if (input.dILT_ILR()) {
                        collector.add(Factory.results().group("ILT - ILR", key + i, "km"), subLinkResult.getInterferingSystemLink().getTxRxDistance());
                    }
                    if (input.dILT_VLR()) {
                        collector.add(Factory.results().group("ILT - VLR", key + i, "km"), d1);
                    }
                    if (input.dILT_VLT()) {
                        collector.add(Factory.results().group("ILT - VLT", key + i, "km"), d2);
                    }
                    if (input.dPosILT()) {
                        collector.add(Factory.results().multi("Position ILT", "x [km]", "y [km]"), posILT);
                    }
                    if (input.dPosVLR()) {
                        collector.add(Factory.results().multi("Position VLR", "x [km]", "y [km]"), posVLR);
                    }
                    if (input.dPosILR()) {
                        collector.add(Factory.results().multi("Position ILR", "x [km]", "y [km]"), posILR);
                    }
                }
                collector.add(Factory.results().value("max distance ILT - VLR", "km"), this.maxD1);
                collector.add(Factory.results().value("max distance ILT - VLT", "km"), this.maxD2);
            }
        }
    }

    @Override
    public void consistencyCheck(ConsistencyCheckContext context, Input input, Validator validator) {
    }

    @Override
    public Description description() {
        return new DescriptionImpl("Demo 8: Collect Distance", "<html>Shows how to extract the victim and interfering<br>distance between Tx and Rx</html>");
    }

    public static interface Input {
        public static final boolean showDetails = false;

        @Config(order=1, name="Show detailed distances", toolTip="otherwise only the max distances are reported", defineGroup="details")
        public boolean showDetails();

        @Config(order=5, name="Distance ILT - ILR", group="details")
        public boolean dILT_ILR();

        @Config(order=7, name="Distance ILT - VLR", group="details")
        public boolean dILT_VLR();

        @Config(order=9, name="Distance ILT - VLT", group="details")
        public boolean dILT_VLT();

        @Config(order=12, name="Position ILT", group="details")
        public boolean dPosILT();

        @Config(order=14, name="Position VLR", group="details")
        public boolean dPosVLR();

        @Config(order=16, name="Position ILR", group="details")
        public boolean dPosILR();
    }
}

