/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.eventprocessing;

import org.seamcat.model.Scenario;
import org.seamcat.model.factory.Factory;
import org.seamcat.model.plugin.Empty;
import org.seamcat.model.plugin.eventprocessing.EventProcessingPlugin;
import org.seamcat.model.plugin.system.ConsistencyCheckContext;
import org.seamcat.model.simulation.consistency.Validator;
import org.seamcat.model.simulation.result.Collector;
import org.seamcat.model.simulation.result.EventResult;
import org.seamcat.model.simulation.result.InterferenceLinkResult;
import org.seamcat.model.simulation.result.VectorDef;
import org.seamcat.model.types.Description;
import org.seamcat.model.types.InterferenceLink;
import org.seamcat.model.types.result.DescriptionImpl;

public class DemoEPP_7_Frequency
implements EventProcessingPlugin<Empty> {
    private static final VectorDef vFreq = Factory.results().value("Frequency victim results", "MHz");

    @Override
    public void evaluate(Scenario scenario, EventResult result, Empty input, Collector collector) {
        String group = "Frequency interferer results";
        collector.add(vFreq, result.getVictimResult().getVictims().get(0).getLinkResult().getFrequency());
        for (InterferenceLink link : scenario.getInterferenceLinks()) {
            String key = link.getInterferer().getName();
            for (int i = 0; i < result.getInterferenceLinkResult(link).size(); ++i) {
                InterferenceLinkResult subLinkResult = result.getInterferenceLinkResult(link).get(i);
                collector.add(Factory.results().group(group, key, "MHz"), subLinkResult.getFrequency());
            }
        }
    }

    @Override
    public void consistencyCheck(ConsistencyCheckContext context, Empty input, Validator validator) {
    }

    @Override
    public Description description() {
        return new DescriptionImpl("Demo 7: Collect Frequency", "<html>Shows how to extract the victim and interfering frequency</html>");
    }
}

