/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.eventprocessing;

import org.seamcat.model.Scenario;
import org.seamcat.model.factory.Factory;
import org.seamcat.model.plugin.eventprocessing.EventProcessingPlugin;
import org.seamcat.model.plugin.system.ConsistencyCheckContext;
import org.seamcat.model.simulation.consistency.Validator;
import org.seamcat.model.simulation.result.Collector;
import org.seamcat.model.simulation.result.EventResult;
import org.seamcat.model.simulation.result.InterferenceLinkResult;
import org.seamcat.model.types.Description;
import org.seamcat.model.types.InterferenceLink;
import org.seamcat.model.types.result.DescriptionImpl;

public class DemoEPP_5_Tx_Power
implements EventProcessingPlugin<Input> {
    @Override
    public void evaluate(Scenario scenario, EventResult result, Input input, Collector collector) {
        String group = "Tx Power results (Interferer - Vector group)";
        double txPower = result.getVictimResult().getVictims().get(0).getLinkResult().getTxPower();
        for (InterferenceLink link : scenario.getInterferenceLinks()) {
            String key = link.getInterferer().getName();
            for (int i = 0; i < result.getInterferenceLinkResult(link).size(); ++i) {
                InterferenceLinkResult subLinkResult = result.getInterferenceLinkResult(link).get(i);
                collector.add(Factory.results().group(group, key, "dBm"), subLinkResult.getTxPower());
            }
        }
        collector.add(Factory.results().value("Tx Power results (victim)", "dBm"), txPower);
    }

    @Override
    public void consistencyCheck(ConsistencyCheckContext context, Input input, Validator validator) {
    }

    @Override
    public Description description() {
        return new DescriptionImpl("Demo 5: Collect Tx power", "<html>Shows how to extract the victim and interfering Tx power</html>");
    }

    public static interface Input {
    }
}

