/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.eventprocessing;

import java.util.List;
import org.seamcat.model.Scenario;
import org.seamcat.model.factory.Factory;
import org.seamcat.model.mathematics.Mathematics;
import org.seamcat.model.plugin.Config;
import org.seamcat.model.plugin.eventprocessing.EventProcessingPlugin;
import org.seamcat.model.plugin.system.ConsistencyCheckContext;
import org.seamcat.model.simulation.consistency.Validator;
import org.seamcat.model.simulation.result.Collector;
import org.seamcat.model.simulation.result.EventResult;
import org.seamcat.model.simulation.result.InterferenceLinkResult;
import org.seamcat.model.simulation.result.LinkResult;
import org.seamcat.model.simulation.result.VectorDef;
import org.seamcat.model.types.Description;
import org.seamcat.model.types.InterferenceLink;
import org.seamcat.model.types.result.DescriptionImpl;
import org.seamcat.model.types.result.DoubleResultType;
import org.seamcat.model.types.result.SingleValueTypes;
import org.seamcat.model.types.result.VectorResultType;
import org.seamcat.simulation.generic.GenericSystemPlugin;
import org.seamcat.simulation.result.ResultsImpl;

public class DemoEPP_4_generate_CoverI_results
implements EventProcessingPlugin<Input> {
    private static VectorDef hiSens = Factory.results().value("High sensitivity", "count");

    @Override
    public void consistencyCheck(ConsistencyCheckContext context, Input input, Validator validator) {
        if (!(context.getScenario().getVictim().getSystemPlugin() instanceof GenericSystemPlugin)) {
            validator.error("VictimSystem must be of type Generic");
        }
    }

    @Override
    public Description description() {
        return new DescriptionImpl("Demo 4: Generate C/I type of results: ", "<html>This Event Processing Plugin allows you to check various C/I, C/(N+I), <br>(N+I)/N and I/N vectors from the calculated dRSS and iRSS. You can select whether <br>you want the sensitivity constraint activated</html>");
    }

    @Override
    public void evaluate(Scenario scenario, EventResult res, Input input, Collector collector) {
        double sensitivity = 0.0;
        double noiseFloor = 0.0;
        GenericSystemPlugin plugin = (GenericSystemPlugin)scenario.getVictim().getSystemPlugin();
        LinkResult victimLink = res.getVictimResult().getVictims().get(0).getLinkResult();
        double dRSS = res.getVictimResult().get(GenericSystemPlugin.DRSS);
        for (int i = 0; i < scenario.getInterferenceLinks().size(); ++i) {
            InterferenceLink link = scenario.getInterferenceLinks().get(i);
            double iRSS = 0.0;
            for (InterferenceLinkResult linkResult : res.getInterferenceLinkResult(link)) {
                iRSS += Math.pow(10.0, linkResult.getRiRSSUnwantedValue() / 10.0);
            }
            iRSS = 10.0 * Math.log10(iRSS);
            sensitivity = plugin.getSensitivity();
            noiseFloor = (Double)victimLink.getValue(GenericSystemPlugin.RX_NOISE_FLOOR);
            if (!input.useSensitivity() || !(dRSS > sensitivity)) continue;
            collector.add(hiSens, 1.0);
            double CoverI = dRSS - iRSS;
            collector.add(Factory.results().value(link.getInterferer().getName() + "C/I", "dBm"), CoverI);
            double rA = Math.pow(10.0, dRSS / 10.0);
            double rB = Math.pow(10.0, iRSS / 10.0);
            double rC = Math.pow(10.0, noiseFloor / 10.0);
            double cOverNI = Mathematics.linear2dB(rA / (rB + rC));
            collector.add(Factory.results().value(link.getInterferer().getName() + "C/(N+I)", "dBm"), cOverNI);
            rB = Math.pow(10.0, iRSS / 10.0);
            rC = Math.pow(10.0, noiseFloor / 10.0);
            double nIOverN = Mathematics.linear2dB((rC + rB) / rC);
            collector.add(Factory.results().value(link.getInterferer().getName() + "(N+I)/N", "dBm"), nIOverN);
            double iOverN = iRSS - noiseFloor;
            collector.add(Factory.results().value(link.getInterferer().getName() + "I/N", "dBm"), iOverN);
        }
    }

    public void postSimulation(Scenario scenario, ResultsImpl results) {
        String textDescription = "Number of event where dRSS > sensitivity out of " + scenario.numberOfEvents();
        VectorResultType vector = results.findVector(hiSens);
        double sum = 0.0;
        for (double v : vector.getValue().asArray()) {
            sum += v;
        }
        results.getVectorResultTypes().remove(vector);
        List<SingleValueTypes<?>> single = results.getSingleValueTypes();
        single.add(new DoubleResultType(Factory.results().single(textDescription, "event"), sum / (double)scenario.getInterferenceLinks().size()));
    }

    public static interface Input {
        public static final boolean useSensitivity = true;

        @Config(order=1, name="use the sensitivity constraint")
        public boolean useSensitivity();
    }
}

