/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.eventprocessing;

import org.seamcat.model.Scenario;
import org.seamcat.model.factory.Factory;
import org.seamcat.model.plugin.Config;
import org.seamcat.model.plugin.eventprocessing.EventProcessingPlugin;
import org.seamcat.model.plugin.system.ConsistencyCheckContext;
import org.seamcat.model.simulation.consistency.Validator;
import org.seamcat.model.simulation.result.Collector;
import org.seamcat.model.simulation.result.EventResult;
import org.seamcat.model.simulation.result.LinkResult;
import org.seamcat.model.simulation.result.VectorDef;
import org.seamcat.model.types.Description;
import org.seamcat.model.types.InterferenceLink;
import org.seamcat.model.types.result.DescriptionImpl;

public class DemoEPP_1_collectIntermediaryResults
implements EventProcessingPlugin<Input> {
    private static final VectorDef VLRX = Factory.results().value("VLR_X pos", "km");
    private static final VectorDef VLRY = Factory.results().value("VLR_Y pos", "km");
    private static final VectorDef VLTX = Factory.results().value("VLT_X pos", "km");
    private static final VectorDef VLTY = Factory.results().value("VLT_Y pos", "km");
    private static final VectorDef VDIST = Factory.results().value("Victim distance", "km");
    private static final VectorDef VANG = Factory.results().value("Victim angle pos", "degree");

    @Override
    public void consistencyCheck(ConsistencyCheckContext context, Input input, Validator validator) {
    }

    @Override
    public Description description() {
        return new DescriptionImpl("Demo 1: Collect intermediary results", "<html>This Event Processing Plugin alllow to select the parameter<br>vector that you want to display after simulation</html>");
    }

    @Override
    public void evaluate(Scenario scenario, EventResult res, Input input, Collector collector) {
        for (InterferenceLink link : scenario.getInterferenceLinks()) {
            LinkResult victimResult = res.getVictimResult().getVictims().get(0).getLinkResult();
            if (input.vlrX()) {
                collector.add(VLRX, victimResult.rxAntenna().getPosition().getX());
            }
            if (input.vlrY()) {
                collector.add(VLRY, victimResult.rxAntenna().getPosition().getY());
            }
            if (input.vltX()) {
                collector.add(VLTX, victimResult.txAntenna().getPosition().getX());
            }
            if (input.vltY()) {
                collector.add(VLTY, victimResult.txAntenna().getPosition().getY());
            }
            if (input.victimDistance()) {
                collector.add(VDIST, victimResult.getTxRxDistance());
            }
            if (input.victimAngle()) {
                collector.add(VANG, victimResult.getTxRxAngle());
            }
            for (int i = 0; i < res.getInterferenceLinkResult(link).size(); ++i) {
                VectorDef def;
                LinkResult subLink = res.getInterferenceLinkResult(link).get(i).getInterferingSystemLink();
                String iName = link.getInterferer().getName() + "_subLink_" + i;
                if (input.ilrX()) {
                    def = Factory.results().value(iName + "_ILR_X pos", "km");
                    collector.add(def, subLink.rxAntenna().getPosition().getX());
                }
                if (input.ilrY()) {
                    def = Factory.results().value(iName + "_ILR_Y pos", "km");
                    collector.add(def, subLink.rxAntenna().getPosition().getY());
                }
                if (input.iltX()) {
                    def = Factory.results().value(iName + "_ILT_X pos", "km");
                    collector.add(def, subLink.txAntenna().getPosition().getX());
                }
                if (input.iltY()) {
                    def = Factory.results().value(iName + "_ILT_Y pos", "km");
                    collector.add(def, subLink.txAntenna().getPosition().getY());
                }
                if (input.interfererDistance()) {
                    def = Factory.results().value(iName + "_Interferer distance", "km");
                    collector.add(def, subLink.getTxRxDistance());
                }
                if (!input.interfererAngle()) continue;
                def = Factory.results().value(iName + "_Interferer angle pos", "degree");
                collector.add(def, subLink.getTxRxAngle());
            }
        }
    }

    public static interface Input {
        @Config(order=1, name="Victim position Rx (X)")
        public boolean vlrX();

        @Config(order=2, name="Victim position Rx (Y)")
        public boolean vlrY();

        @Config(order=3, name="Victim position Tx (X)")
        public boolean vltX();

        @Config(order=4, name="Victim position Tx (y)")
        public boolean vltY();

        @Config(order=5, name="Victim Distance")
        public boolean victimDistance();

        @Config(order=6, name="Victim Angle")
        public boolean victimAngle();

        @Config(order=7, name="Interferer position Rx (X)")
        public boolean ilrX();

        @Config(order=8, name="Interferer position Rx (Y)")
        public boolean ilrY();

        @Config(order=9, name="Interferer position Tx (X)")
        public boolean iltX();

        @Config(order=10, name="Interferer position Tx (Y)")
        public boolean iltY();

        @Config(order=11, name="Interferer Distance")
        public boolean interfererDistance();

        @Config(order=12, name="Interferer Angle")
        public boolean interfererAngle();
    }
}

