/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.cdma;

import org.seamcat.cdma.CDMADownlink;
import org.seamcat.cdma.CDMASystem;
import org.seamcat.cdma.CdmaUserTerminal;
import org.seamcat.cdma.exceptions.ScalingException;
import org.seamcat.dmasystems.AbstractDmaBaseStation;
import org.seamcat.dmasystems.AbstractDmaLink;
import org.seamcat.model.geometry.Point2D;
import org.seamcat.model.mathematics.Mathematics;
import org.seamcat.simulation.cdma.CDMADownLinkSimulation;

public abstract class CdmaBaseStation
extends AbstractDmaBaseStation {
    protected CDMASystem cdmasystem;
    private int inactiveSize;
    private int activeSize;
    private double cacheValue;
    private boolean worstCell = false;

    public CdmaBaseStation(Point2D position, CDMASystem _system, int _cellid, double antHeight, double antennaTilt, int sectorId) {
        super(position, _system, _cellid, antHeight, antennaTilt, sectorId);
        this.cdmasystem = _system;
        this.inactiveSize = 0;
        this.activeSize = 0;
        this.cacheValue = 0.0;
    }

    public double calculateCurrentChannelPower_dBm() {
        if (this.activeSize < this.activeConnections.size()) {
            for (int i = this.activeSize; i < this.activeConnections.size(); ++i) {
                this.cacheValue += ((AbstractDmaLink)this.activeConnections.get(i)).getTransmittedTrafficChannelPowerWatt();
                ++this.activeSize;
            }
        }
        this.setCurrentChannelTransmitPower(Mathematics.fromWatt2dBm(this.cacheValue));
        return this.getCurrentChannelTransmitPower();
    }

    public double calculateInterSystemInterference_dBm(AbstractDmaLink excludelink) {
        int i;
        if (this.activeSize < this.activeConnections.size()) {
            for (i = this.activeSize; i < this.activeConnections.size(); ++i) {
                this.cacheValue = Mathematics.powerSummation(this.cacheValue, ((AbstractDmaLink)this.activeConnections.get(this.activeSize)).calculateCurrentReceivePower_dBm());
                ++this.activeSize;
            }
        }
        if (this.inactiveSize < this.inActiveConnections.size()) {
            for (i = this.inactiveSize; i < this.inActiveConnections.size(); ++i) {
                this.cacheValue = Mathematics.powerSummation(this.cacheValue, ((AbstractDmaLink)this.inActiveConnections.get(this.inactiveSize)).calculateCurrentReceivePower_dBm());
                ++this.inactiveSize;
            }
        }
        if (excludelink != null && !this.activeConnections.contains(excludelink) && !this.inActiveConnections.contains(excludelink)) {
            this.setInterSystemInterference(Mathematics.powerSummation(this.cacheValue, excludelink.calculateCurrentReceivePower_dBm()));
            excludelink = null;
        }
        if (this.cacheValue == 0.0) {
            this.setInterSystemInterference(-1000.0);
        } else {
            this.setInterSystemInterference(this.cacheValue);
        }
        if (excludelink == null) {
            if (this.cacheValue == 0.0) {
                return -1000.0;
            }
            return this.cacheValue;
        }
        double sub = excludelink.calculateCurrentReceivePower_dBm();
        if (this.cacheValue < sub) {
            return -1000.0;
        }
        double v = Mathematics.powerSubtract(this.cacheValue, sub);
        if (Math.abs(v) < 0.001) {
            return -1000.0;
        }
        return v;
    }

    @Override
    public void removeActive(AbstractDmaLink link) {
        super.removeActive(link);
        if (this.isUpLinkMode()) {
            this.resetSummedInterference();
        } else if (this.activeSize > 0) {
            this.cacheValue -= link.getTransmittedTrafficChannelPowerWatt();
            --this.activeSize;
        }
        this.setInterSystemInterference(this.cacheValue);
    }

    @Override
    public void removeInActive(AbstractDmaLink link) {
        super.removeInActive(link);
        if (this.isUpLinkMode()) {
            this.resetSummedInterference();
        } else {
            --this.inactiveSize;
        }
        this.setInterSystemInterference(this.cacheValue);
    }

    @Override
    public void deinitializeConnection(AbstractDmaLink link) {
        if (this.activeConnections.contains(link) && !this.inActiveConnections.contains(link)) {
            --this.activeSize;
            ++this.inactiveSize;
        } else if (this.activeConnections.contains(link) && this.inActiveConnections.contains(link)) {
            throw new RuntimeException("Consistency error: link both in active and in-active connections");
        }
        super.deinitializeConnection(link);
    }

    @Override
    public void intializeConnection(AbstractDmaLink link) {
        if (this.inActiveConnections.contains(link) && !this.activeConnections.contains(link)) {
            --this.inactiveSize;
            ++this.activeSize;
        } else if (this.inActiveConnections.contains(link) && this.activeConnections.contains(link)) {
            throw new RuntimeException("Consistency error: link both in active and in-active connections");
        }
        super.intializeConnection(link);
    }

    @Override
    public double calculateOutage() {
        double connected = this.countActiveUsers();
        if ((connected += (double)this.countInActiveUsers()) < 1.0) {
            return 1.0;
        }
        double dropped = this.countDroppedUsers();
        double outage = 0.0;
        outage = connected + dropped == 0.0 || dropped == 0.0 ? dropped : dropped / (connected + dropped);
        return outage;
    }

    public double calculateScaling() {
        double pMax = this.getMaximumChannelPower_Watt();
        double pCalc = this.getCurrentChannelTransmitPowerInWatts();
        if (pCalc > pMax) {
            return pMax / pCalc;
        }
        return 1.0;
    }

    @Override
    public double calculateTotalInterference_dBm(AbstractDmaLink link) {
        double internalSystem = Mathematics.fromdBm2Watt(this.calculateInterSystemInterference_dBm(link));
        double external = Mathematics.fromdBm2Watt(this.getExternalInterference());
        double thermal = Mathematics.fromdBm2Watt(this.getSystem().getPreSimulation().findDoubleValue(CDMADownLinkSimulation.THERMAL_NOISE));
        double totalInterference = Mathematics.fromWatt2dBm(internalSystem + external + thermal);
        this.setTotalInterference(totalInterference);
        return this.getTotalInterference();
    }

    @Override
    public double calculateInterferenceWithoutExternal_dBm(AbstractDmaLink link) {
        double internalSystem = Mathematics.fromdBm2Watt(this.calculateInterSystemInterference_dBm(link));
        double thermal = Mathematics.fromdBm2Watt(this.getSystem().getPreSimulation().findDoubleValue(CDMADownLinkSimulation.THERMAL_NOISE));
        return Mathematics.fromWatt2dBm(internalSystem + thermal);
    }

    public CDMASystem getCdmasystem() {
        return (CDMASystem)this.getSystem();
    }

    public double getCurrentChannelTransmitPowerInWatts() {
        return Mathematics.fromdBm2Watt(this.getCurrentChannelTransmitPower());
    }

    @Override
    public double getCurrentTransmitPower_dBm() {
        return Mathematics.powerSummation(this.calculateCurrentChannelPower_dBm(), this.getOverheadTransmitPower(), this.getPilotTransmitPower());
    }

    public double getMaximumChannelPower_Watt() {
        return Mathematics.fromdBm2Watt(this.getMaximumTransmitPower()) * (1.0 - (this.getOverheadFraction() + this.getPilotFraction()));
    }

    public double getOverheadPower_Watt() {
        return Mathematics.fromdBm2Watt(this.getMaximumTransmitPower()) * this.getOverheadFraction();
    }

    public double getPilotPower_Watt() {
        return Mathematics.fromdBm2Watt(this.getMaximumTransmitPower()) * this.getPilotFraction();
    }

    public void initializeTransmitPowerLevels() {
        double maxPowerInWatts = Mathematics.fromdBm2Watt(this.getMaximumTransmitPower());
        this.setPilotTransmitPower(Mathematics.fromWatt2dBm(maxPowerInWatts * this.getPilotFraction()));
        this.setOverheadTransmitPower(Mathematics.fromWatt2dBm(maxPowerInWatts * this.getOverheadFraction()));
        this.setCurrentChannelTransmitPower(Mathematics.fromWatt2dBm(0.0));
    }

    @Override
    public void resetBaseStation() {
        this.resetCell();
    }

    public void resetCell() {
        this.activeConnections.clear();
        this.inActiveConnections.clear();
        this.droppedUsers.clear();
        this.inactiveUsers.clear();
        this.resetSummedInterference();
        this.setCurrentChannelTransmitPower(Mathematics.fromWatt2dBm(0.0));
        this.setExternalInterferenceUnwanted(-1000.0);
        this.setExternalInterferenceBlocking(-1000.0);
    }

    public void resetSummedInterference() {
        this.activeSize = 0;
        this.inactiveSize = 0;
        this.cacheValue = 0.0;
    }

    public void scaleChannelPower() throws ScalingException {
        this.scaleChannelPower(this.calculateScaling());
    }

    public void scaleChannelPower(double scaleFactor) throws ScalingException {
        int i;
        if (scaleFactor == 1.0) {
            return;
        }
        if (scaleFactor > 1.0) {
            throw new ScalingException("CDMA Power levels cannot be scaled up. [Scale value was: " + scaleFactor + "]");
        }
        this.cacheValue = 0.0;
        this.activeSize = 0;
        for (i = 0; i < this.activeConnections.size(); ++i) {
            ((CDMADownlink)this.activeConnections.get(i)).scaleTransmitPower(scaleFactor);
        }
        this.calculateCurrentChannelPower_dBm();
        for (i = 0; i < this.activeConnections.size(); ++i) {
            CdmaUserTerminal u = (CdmaUserTerminal)((AbstractDmaLink)this.activeConnections.get(i)).getUserTerminal();
            try {
                u.calculateReceivedPower();
                u.calculateAchievedEcIor();
                if (u.meetsEcIorRequirement(this.cdmasystem.getCDMASettings().getCallDropThreshold())) continue;
                this.cdmasystem.dropActiveUser(u, "Ec/Ior requirement does not meet while scaling the channel power");
                --i;
                continue;
            }
            catch (Exception ex) {
                throw new ScalingException(ex);
            }
        }
    }

    public String toString() {
        return "CDMA Cell # " + this.getCellid() + " at " + this.getPosition() + (this.isUpLinkMode() ? " - Noise Rise: " + this.getNoiseRise() + "dB" : "");
    }

    public void setWorstCell(boolean worstCell) {
        this.worstCell = worstCell;
    }

    public boolean isWorstCell() {
        return this.worstCell;
    }
}

