/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.cdma;

import org.seamcat.cdma.CDMASystem;
import org.seamcat.cdma.CdmaBaseStation;
import org.seamcat.cdma.CdmaUserTerminal;
import org.seamcat.dmasystems.AbstractDmaLink;
import org.seamcat.simulation.cdma.CDMADownLinkSimulation;

public class CDMAUplink
extends AbstractDmaLink {
    protected CDMASystem cdmasystem;
    private CdmaUserTerminal ue;

    public CDMAUplink(CdmaBaseStation _cell, CdmaUserTerminal _user, CDMASystem _cdmasystem) {
        super(true, _cell, _user, _cdmasystem.getFrequency());
        this.cdmasystem = _cdmasystem;
        this.ue = _user;
    }

    public double calculateAchivedCI() {
        double procGain = this.cdmasystem.getProcessingGain();
        double Itotal = this.getBaseStation().calculateTotalInterference_dBm(this);
        double recPower = this.getTotalReceivedPower();
        return procGain + recPower - Itotal;
    }

    @Override
    public CdmaUserTerminal getUserTerminal() {
        return this.ue;
    }

    @Override
    public double calculateCurrentReceivePower_dBm() {
        this.totalReceivedPower = this.ue.getCurrentTransmitPowerIndBm() - this.effectivePathLoss;
        return this.totalReceivedPower;
    }

    public double calculateInitialReceivePower() {
        double thermalNoise_dB = this.cdmasystem.getPreSimulation().findDoubleValue(CDMADownLinkSimulation.THERMAL_NOISE);
        double noiseRise_target_dB = this.cdmasystem.getCDMASettings().getUpLinkSettings().getTargetNetworkNoiseRise();
        double sir_target_db = this.getUserTerminal().getLinkLevelData().getEbNo();
        double processing_gain_db = this.cdmasystem.getProcessingGain();
        this.totalReceivedPower = thermalNoise_dB + noiseRise_target_dB + sir_target_db - processing_gain_db;
        return this.totalReceivedPower;
    }

    @Override
    public void activateLink() {
    }

    public double calculateTotalTransmitPower(double receivePower) {
        double eff = this.getEffectivePathloss();
        double totalTransmitPower = receivePower + eff;
        double maxTxPower = this.cdmasystem.getCDMASettings().getUpLinkSettings().getMSMaximumTransmitPower();
        double minTxPower = maxTxPower - this.cdmasystem.getCDMASettings().getUpLinkSettings().getMSPowerControlRange();
        if (totalTransmitPower > maxTxPower) {
            totalTransmitPower = maxTxPower;
        } else if (totalTransmitPower < minTxPower) {
            totalTransmitPower = minTxPower;
        }
        this.getUserTerminal().setCurrentTransmitPower_dBm(totalTransmitPower);
        return totalTransmitPower;
    }

    public double initializePowerLevels() {
        this.calculateInitialReceivePower();
        this.calculateTotalTransmitPower(this.totalReceivedPower);
        return this.calculateAchivedCI();
    }
}

