/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.cdma;

import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.seamcat.cdma.CDMADownlinkSystem;
import org.seamcat.cdma.CDMALinkLevelData;
import org.seamcat.cdma.CDMAOmniDirectionalCell;
import org.seamcat.cdma.CDMATriSectorCell;
import org.seamcat.cdma.CdmaBaseStation;
import org.seamcat.cdma.CdmaUserTerminal;
import org.seamcat.cdma.NonInterferedCapacitySearch;
import org.seamcat.dmasystems.AbstractDmaBaseStation;
import org.seamcat.dmasystems.AbstractDmaSystem;
import org.seamcat.eventbus.EventBusFactory;
import org.seamcat.events.CapacityStartingCapacityFinding;
import org.seamcat.model.factory.Factory;
import org.seamcat.model.geometry.Point2D;
import org.seamcat.model.mathematics.Mathematics;
import org.seamcat.model.simulation.result.MultiValueDef;
import org.seamcat.model.simulation.result.UniqueValueDef;
import org.seamcat.model.types.result.BarChartResultType;
import org.seamcat.model.types.result.BarChartValue;
import org.seamcat.model.types.result.IntegerResultType;
import org.seamcat.model.types.result.Results;
import org.seamcat.simulation.cellular.cdma.CDMASettings;
import org.seamcat.simulation.hybrid.HybridSystemPlugin;

public abstract class CDMASystem
extends AbstractDmaSystem<CdmaUserTerminal> {
    private static Logger LOG = Logger.getLogger(CDMASystem.class);
    public static final UniqueValueDef NON_INTERFERED_CAPACITY = Factory.results().single("Non interfered capacity", "users");
    protected boolean finalFineTuning = false;
    protected boolean fineTuning = false;
    protected double maxTargetNoiseRise;
    protected double minTargetNoiseRise;
    protected double meanNoiseRiseOverTrials;
    protected double succesCriteria = 0.8;
    protected List<CdmaUserTerminal> inactiveUsers = new ArrayList<CdmaUserTerminal>();
    protected List<CdmaUserTerminal> droppedUsers = new ArrayList<CdmaUserTerminal>();
    public static final MultiValueDef CAPACITY_UP_LINK = Factory.results().multi("Capacity finding", "Users per cell", "Average Noiserise (dB)");
    public static final MultiValueDef CAPACITY_DOWN_LINK = Factory.results().multi("Capacity finding", "Users per cell", "Successful trials");

    public CDMASystem(HybridSystemPlugin plugin) {
        this.setPlugin(plugin);
    }

    protected CDMASystem(AbstractDmaSystem<?> sys) {
        super(sys);
        this.getPlugin().setOFDMASettings(null);
        if (sys instanceof CDMASystem) {
            CDMASystem cdma = (CDMASystem)sys;
            this.getPlugin().setCDMASettings(((CDMASystem)sys).getCDMASettings());
            this.setFrequency(cdma.getFrequency());
            this.setLocation(cdma.getLocationX(), cdma.getLocationY());
            this.setSuccesCriteria(cdma.getSuccesCriteria());
            this.setVictimSystem(cdma.isVictimSystem());
        }
        if (this.getCDMASettings() == null) {
            this.getPlugin().setCDMASettings(new CDMASettings());
        }
    }

    public abstract void balanceInterferedSystem();

    public abstract void balancePower();

    @Override
    public void resetSystem() {
        super.resetSystem();
        this.droppedUsers.clear();
        this.inactiveUsers.clear();
    }

    public int countDroppedUsers() {
        return this.droppedUsers.size();
    }

    public int countInactivateUsers() {
        return this.inactiveUsers.size();
    }

    public int countTotalNumberOfUsers() {
        return this.countActiveUsers() + this.countDroppedUsers() + this.countInactivateUsers();
    }

    public List<CdmaUserTerminal> getInactiveUsers() {
        return this.inactiveUsers;
    }

    public List<CdmaUserTerminal> getDroppedUsers() {
        return this.droppedUsers;
    }

    @Override
    protected void generateAndPositionMobiles() {
        int capacity = this.getCollector().getInt(NON_INTERFERED_CAPACITY);
        int stop = capacity * this.getNumberOfBaseStations();
        for (int i = 0; i < stop; ++i) {
            CdmaUserTerminal user = (CdmaUserTerminal)this.generateInitializedMobile();
            if (user == null) continue;
            if (user.connect()) {
                user.setAllowedToConnect(true);
                this.activeUsers.add(user);
                continue;
            }
            this.dropActiveUser(user, "Unable to connect during first initialisation of UE");
        }
    }

    public void dropActiveUser(CdmaUserTerminal user, String reason) {
        user.dropCall();
        this.activeUsers.remove(user);
        this.getDroppedUsers().add(user);
        user.setDropReason(reason);
    }

    public boolean trialVoiceActivity() {
        return this.random.trial() <= this.getCDMASettings().getVoiceActivityFactor();
    }

    public double calculateProcessingGain() {
        this.processingGain = this.getPlugin().getBandwidth() / this.getCDMASettings().getVoiceBitRate() * 1000.0;
        this.processingGain = Mathematics.linear2dB(this.processingGain);
        return this.processingGain;
    }

    @Override
    protected void configureBaseStation(AbstractDmaBaseStation base) {
        if (this instanceof CDMADownlinkSystem) {
            base.setMaximumTransmitPower_dBm(this.getCDMASettings().getDownLinkSettings().getMaximumBroadcastChannel());
            base.setPilotFraction(this.getCDMASettings().getDownLinkSettings().getPilotChannelFraction());
            base.setOverheadFraction(this.getCDMASettings().getDownLinkSettings().getOverheadChannelFraction());
        } else {
            base.setMaximumTransmitPower_dBm(40.0);
            base.setPilotFraction(0.15);
            base.setOverheadFraction(0.05);
        }
        ((CdmaBaseStation)base).initializeTransmitPowerLevels();
    }

    public CDMASettings getCDMASettings() {
        return this.getPlugin().getCDMASettings();
    }

    protected abstract NonInterferedCapacitySearch findNonInterferedCapacityInternal(Results var1, MultiValueDef var2, NonInterferedCapacitySearch var3, Object var4);

    public void findNonInterferedCapacity(Results results, Object context) {
        if (results.hasSingleValue(NON_INTERFERED_CAPACITY)) {
            return;
        }
        int capacity = this.getPlugin().getUsersPerCell();
        if (this.getCDMASettings().isSimulateNonInterferedCapacity()) {
            MultiValueDef def;
            this.fineTuning = false;
            int deltaN = this.getCDMASettings().getDeltaUsersPerCell();
            if (this.isUplink()) {
                def = CAPACITY_UP_LINK;
                double noiseRise = this.getCDMASettings().getUpLinkSettings().getTargetNetworkNoiseRise();
                this.minTargetNoiseRise = noiseRise - this.getCDMASettings().getTargetNoiseRisePrecision();
                this.maxTargetNoiseRise = noiseRise;
                EventBusFactory.getEventBus().publish(new CapacityStartingCapacityFinding(context, this.getPlugin().getUsersPerCell(), deltaN, this.getCDMASettings().getTargetNoiseRisePrecision(), this.getCDMASettings().getNumberOfTrials(), true, noiseRise));
            } else {
                def = CAPACITY_DOWN_LINK;
                EventBusFactory.getEventBus().publish(new CapacityStartingCapacityFinding(context, this.getPlugin().getUsersPerCell(), deltaN, this.getCDMASettings().getToleranceOfInitialOutage(), this.getCDMASettings().getNumberOfTrials(), false, this.succesCriteria));
            }
            NonInterferedCapacitySearch search = new NonInterferedCapacitySearch(this.getPlugin().getUsersPerCell(), deltaN);
            search = this.findNonInterferedCapacityInternal(results, def, search, context);
            while (!search.isConverged()) {
                search = this.findNonInterferedCapacityInternal(results, def, search, context);
            }
            capacity = search.getCapacity();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Initial Capacity found: " + capacity + " users per cell");
            }
        }
        results.getSingleValueTypes().add(new IntegerResultType(NON_INTERFERED_CAPACITY, capacity));
    }

    protected void addPoint(int num, Results results, MultiValueDef def, int usersPerCell, double value) {
        BarChartResultType barChart = results.findBarChart(def);
        if (barChart == null) {
            barChart = new BarChartResultType(def);
            results.getBarChartResultTypes().add(barChart);
        }
        barChart.value().add(new BarChartValue(num + "#Users: " + usersPerCell, value));
    }

    @Override
    protected CdmaBaseStation generateBaseStation(Point2D position, int cellid, double antennaHeight, double antennaTilt, int sectorid, boolean triSector) {
        if (triSector) {
            return new CDMATriSectorCell(position, this, cellid, antennaHeight, antennaTilt, sectorid);
        }
        return new CDMAOmniDirectionalCell(position, this, cellid, antennaHeight, antennaTilt);
    }

    protected CdmaBaseStation[][] generateBaseStationArray() {
        return new CdmaBaseStation[this.getNumberOfCellSitesInPowerControlCluster()][this.cellsPerSite()];
    }

    @Override
    public CdmaUserTerminal generateUserTerminal() {
        CdmaUserTerminal user = new CdmaUserTerminal(new Point2D(0.0, 0.0), this, this.useridcount++, this.getPlugin().getMs().getAntennaGain().trial(), this.getPlugin().getMs().getAntennaHeight().trial());
        user.setUpLinkMode(this.isUplink());
        return user;
    }

    public final CDMALinkLevelData getLinkLevelData() {
        return this.getCDMASettings().getLld();
    }

    public int getNumberOfNoLinkLevelDataUsers() {
        return this.noLinkLevelFoundUsers.size();
    }

    public double getSuccesCriteria() {
        return this.succesCriteria;
    }

    protected abstract int internalPowerBalance();

    public final void setLinkLevelData(CDMALinkLevelData linkLevelData) {
        this.getCDMASettings().setLld(linkLevelData);
    }

    public void setSuccesCriteria(double succesCriteria) {
        this.succesCriteria = succesCriteria;
    }

    @Override
    public void simulate() {
        if (LOG.isDebugEnabled()) {
            LOG.debug(" Generating And Positioning mobiles: " + this.toString());
            LOG.debug(" System Description: CDMA System");
            LOG.debug(" System Minimum coupling loss: " + this.getPlugin().getMinimumCouplingLoss() + " dBm");
            LOG.debug(" Calculate the thermal noise()");
        }
        this.generateAndPositionMobiles();
        this.balancePower();
    }
}

